% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/position-nudge-center.R
\name{position_nudge_keep}
\alias{position_nudge_keep}
\title{Nudge points a fixed distance}
\usage{
position_nudge_keep(
  x = 0,
  y = 0,
  obey_grouping = NULL,
  kept.origin = c("original", "none")
)
}
\arguments{
\item{x, y}{Amount of vertical and horizontal distance to move. A numeric
vector of length 1, or of the same length as rows there are in \code{data},
with nudge values in data rows order.}

\item{obey_grouping}{A logical flag indicating whether to obey or not
groupings of the observations. By default, grouping is obeyed when both of
the variables mapped to \emph{x} and \emph{y} are continuous numeric and
ignored otherwise.}

\item{kept.origin}{One of \code{"original"} or \code{"none"}.}
}
\value{
A \code{"Position"} object.
}
\description{
The function \code{position_nudge_keep()} has an additional parameters
compared to \code{\link[ggplot2]{position_nudge}}, \code{obey_grouping} and
by default the same behaviour when the values passed as arguments to \code{x}
and \code{y} have length one.
}
\details{
When \code{x} or \code{y} have length > 1, they are treated
  specially. If the lengths is the same as there are rows in data, the nudges
  are applied in the order of the rows in data. When they are shorter, they
  are recycled and applied to the data values after ordering. This makes it
  possible to have alternating mudging right and left or up and down. If
  \code{obey_grouping = TRUE} is passed in the call, the alternation will
  take place within groups.

  As other position functions from package 'ggpp', \code{position_nudge_keep()}
  by default renames and keeps the original positions of the observations in
  \code{data} making it possible to draw connecting segments or conencting
  arrows.
}
\note{
Irrespective of the action, the ordering of rows in \code{data} is
  preserved.
}
\examples{
df <- data.frame(
  x = c(1,3,2,5,4,2.5),
  y = c("abc","cd","d","c","bcd","a")
)

# Plain nudging, same as with ggplot2::position_nudge()

ggplot(df, aes(x, y, label = y)) +
  geom_point() +
  geom_text_s(hjust = "left", vjust = "bottom",
              position = position_nudge_keep(x = 0.2, y = 0.2))

# alternating nudging
ggplot(df, aes(x, y, label = y)) +
  geom_point() +
  geom_text_s(position = position_nudge_keep(x = c(0.2, -0.2)))

# direct nudging
ggplot(df, aes(x, y, label = y)) +
  geom_point() +
  geom_text_s(position = position_nudge_keep(x = rep_len(c(0.2, -0.2), 6)))

}
\seealso{
Other position adjustments: 
\code{\link{position_dodgenudge}()},
\code{\link{position_dodgenudge_to}()},
\code{\link{position_jitternudge}()},
\code{\link{position_nudge_center}()},
\code{\link{position_nudge_line}()},
\code{\link{position_nudge_to}()},
\code{\link{position_stacknudge}()},
\code{\link{position_stacknudge_to}()}
}
\concept{position adjustments}
