% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggsegmentedtotalbar.R
\name{ggsegmentedtotalbar}
\alias{ggsegmentedtotalbar}
\title{Create a segmented total bar plot with custom annotations and labels}
\usage{
ggsegmentedtotalbar(
  df,
  group,
  segment,
  value,
  total,
  alpha = 0.3,
  color = "lightgrey",
  label = FALSE,
  label_size = 4,
  label_color = "black"
)
}
\arguments{
\item{df}{A data frame containing the data to be plotted.}

\item{group}{A string specifying the column name for the grouping variable.}

\item{segment}{A string specifying the column name for the segmenting variable (used for fill color).}

\item{value}{A string specifying the column name for the value variable (used for the bar heights).}

\item{total}{A string specifying the column name for the total variable (used for determining the background box height).}

\item{alpha}{A numeric value (between 0 and 1) controlling the transparency of the background boxes. Default is 0.3.}

\item{color}{A string specifying the color of the background boxes. Default is "lightgrey".}

\item{label}{Logical. If `TRUE`, adds labels showing total values above the boxes and value labels on each segment. Default is `FALSE`.}

\item{label_size}{Numeric. Text size for the labels. Default is 4.}

\item{label_color}{A string specifying the color of the labels. Default is "black".}
}
\value{
A ggplot object displaying the segmented bar plot with optional annotations and labels.
}
\description{
This function creates a segmented bar plot where each bar represents a group,
divided into segments. Additionally, a background box is drawn behind each bar
up to the group's total value. Optionally, total values and segment values can
be displayed as labels on the plot.
}
\details{
The group levels are ordered from the group with the highest total value
to the one with the lowest.
}
\examples{
df_ex <- data.frame(
  group = rep(c("West", "East", "Central", "South"), each = 3),
  segment = rep(c("Consumer", "Corporate", "Home Office"), 4),
  value = c(364, 232, 143, 357, 204, 131, 254, 158, 91, 196, 122, 74),
  total = rep(c(739, 692, 503, 392), each = 3)
)
ggsegmentedtotalbar(df_ex, group = "group", segment = "segment",
                    value = "value", total = "total", label = TRUE)

}
