% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmDataFrameStack.R
\name{gmApply}
\alias{gmApply}
\alias{gmApply.default}
\alias{gmApply.DataFrameStack}
\title{Apply Functions Over Array or DataFrameStack Margins}
\usage{
gmApply(X, ...)

\method{gmApply}{default}(X, MARGIN, FUN, ...)

\method{gmApply}{DataFrameStack}(X, MARGIN = stackDim(X), FUN, ..., .parallel = FALSE)
}
\arguments{
\item{X}{a \code{\link[=DataFrameStack]{DataFrameStack()}} object (see \code{\link[base:apply]{base::apply()}} for other options)}

\item{...}{further arguments to \code{FUN}}

\item{MARGIN}{a name or an index of the dimension along which should
the calculations be done; defaults to the stacking dimension of the
\code{\link[=DataFrameStack]{DataFrameStack()}}, i.e. to the output of \code{stackDim(X)}}

\item{FUN}{function to apply; the default behaviour being that this function
is applied to each element of the stack \code{X}}

\item{.parallel}{currently ignored}
}
\value{
In principle, if \code{MARGIN==stackDim(X)} (the default), the oputput is a list
with the result of using \code{FUN} on each element of the stack. If \code{FUN} returns a
matrix or a data.frame assimilable to one element of the stack, a transformation of
this output to a DataFrameStack is attempted.

For \code{X} non-DataFrameStack or \code{MARGIN!=stackDim(X)} see \code{\link[base:apply]{base::apply()}}.
}
\description{
Returns a vector or array or list of values obtained by
applying a function to the margins of an array or matrix.
Method \code{gmApply.default()} is just a wrapper on \code{\link[base:apply]{base::apply()}}.
Method \code{gmApply()} reimplements the functionality
with future access to parallel computing and appropriate default
values for the MARGIN. ALWAYS use named arguments here!
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: wrapper around \code{\link[base:apply]{base::apply()}}

\item \code{DataFrameStack}: Apply Functions Over DataFrameStack Margins
}}

\examples{
dm = list(point=1:100, var=LETTERS[1:2], rep=paste("r",1:5, sep=""))
ar = array(rnorm(1000), dim=c(100,2,5), dimnames = dm)
dfs = DataFrameStack(ar, stackDim="rep")
gmApply(dfs, FUN=colMeans)
rs = gmApply(dfs, FUN=function(x) x+1)
class(rs)
getStackElement(rs,1)
getStackElement(dfs,1)
}
