% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_leaderboard.R
\name{load_leaderboard}
\alias{load_leaderboard}
\alias{get_tournament_leaderboard}
\title{Load Tournament Leaderboard}
\usage{
load_leaderboard(
  year = as.integer(format(Sys.Date(), "\%Y")),
  tournament = NULL,
  tour = "pga"
)

get_tournament_leaderboard(event_id)
}
\arguments{
\item{year}{Season year (e.g., 2026). Defaults to current year.}

\item{tournament}{Tournament identifier - either event_id or partial name match.
If NULL, returns all tournaments for the year.}

\item{tour}{Tour identifier. Currently supports "pga" (default).}

\item{event_id}{ESPN event identifier (for legacy function)}
}
\value{
A tibble with leaderboard data including:
  \itemize{
    \item \code{position}: Final standing
    \item \code{player_id}: ESPN athlete ID
    \item \code{player_name}: Player display name
    \item \code{total_score}: Total strokes
    \item \code{score_to_par}: Score relative to par (e.g., "-11")
    \item \code{tournament_id}: Event ID
    \item \code{tournament_name}: Tournament name
  }

A tibble with leaderboard data
}
\description{
Retrieves leaderboard data for tournaments. Can load a single tournament
or all tournaments for a year.
}
\section{Functions}{
\itemize{
\item \code{get_tournament_leaderboard()}: Legacy function for backwards compatibility

}}
\examples{
\donttest{
# Load specific tournament by name
sony <- load_leaderboard(2026, "Sony")
}
}
