#' Data based on Nederhof, Ormel, and Oldehinkel (2014)
#'
#' Synthetic data, (N = 310) based on Nederhof, Ormel, and Oldehinkel (2014).
#' The 11 years old participants are divided into three groups:
#' Sustainers, Shifters, and Comparison group, based on their
#' performance on a sustained-attention task and on a shifting-set task. The
#' outcome depressive episode (D: no depressive episode, versus experienced an
#' episode) is predicted by the categorical variable early life
#' stress (ES: Low versus High), the standardized continuous variable recent
#' stress, RS, and the interaction between both predictors. The continuous
#' variable recent stress, RS, is standardized to improve the interpretation of
#' main effects when interactions exist.
#'
#' \tabular{lll}{
#'   \strong{Groups} \tab \code{factor} \tab Group membership\cr
#'   \strong{RS} \tab \code{numeric} \tab Recent stress\cr
#'   \strong{ES} \tab \code{Factor} \tab Early life stress\cr
#'   \strong{D} \tab \code{Factor} \tab Experienced a depressive episode
#' }
#' @docType data
#' @keywords datasets
#' @name nederhof_2014
#' @usage data(nederhof_2014)
#' @references Nederhof, E., Ormel, J., & Oldehinkel, A. J. (2014).
#' Mismatch or cumulative stress: The pathway to depression is conditional on
#' attention style. Psychological Science, 25, 684-692.
#' \doi{10.1177/0956797613513473}.
#' @format A data frame with 310 rows and 4 variables.
NULL
