% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cut_completers.R
\name{cut_completers}
\alias{cut_completers}
\title{Cut data for completers analysis}
\usage{
cut_completers(data, cut_date, event_gap = 0)
}
\arguments{
\item{data}{Data generated by \code{\link[=nb_sim]{nb_sim()}}.}

\item{cut_date}{Calendar time (relative to trial start) at which to cut the data.}

\item{event_gap}{Gap duration after each event during which no new events are counted.
Can be a numeric value (default \code{0}) or a function returning a numeric value.
The time at risk is reduced by the sum of these gaps (truncated by the cut date).}
}
\value{
A data frame with one row per subject randomized prior to \code{cut_date}.
Contains the truncated follow-up time (\code{tte}) and total number of observed events (\code{events}).
}
\description{
Subsets the data to all subjects randomized by the specified date,
and prepares the data for analysis. This is a wrapper for \code{\link[=cut_data_by_date]{cut_data_by_date()}}
typically used with a date determined by \code{\link[=cut_date_for_completers]{cut_date_for_completers()}}.
}
\examples{
enroll_rate <- data.frame(rate = 20 / (5 / 12), duration = 5 / 12)
fail_rate <- data.frame(treatment = c("Control", "Experimental"), rate = c(0.5, 0.3))
dropout_rate <- data.frame(
  treatment = c("Control", "Experimental"),
  rate = c(0.1, 0.05), duration = c(100, 100)
)
sim <- nb_sim(enroll_rate, fail_rate, dropout_rate, max_followup = 2, n = 20)
# Find date when 5 subjects have completed
date_5 <- cut_date_for_completers(sim, 5)
# Get analysis dataset for this cut date (includes partial follow-up)
cut_completers(sim, date_5)
}
