% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmt_number.R
\name{fmt_integer}
\alias{fmt_integer}
\title{Format values as integers}
\usage{
fmt_integer(
  data,
  columns = everything(),
  rows = everything(),
  use_seps = TRUE,
  accounting = FALSE,
  scale_by = 1,
  suffixing = FALSE,
  pattern = "{x}",
  sep_mark = ",",
  force_sign = FALSE,
  min_sep_threshold = 1,
  system = c("intl", "ind"),
  locale = NULL
)
}
\arguments{
\item{data}{\emph{The gt table data object}

\verb{obj:<gt_tbl>} // \strong{required}

This is the \strong{gt} table object that is commonly created through use of the
\code{\link[=gt]{gt()}} function.}

\item{columns}{\emph{Columns to target}

\code{\link[=rows-columns]{<column-targeting expression>}} // \emph{default:} \code{everything()}

Can either be a series of column names provided in \code{c()}, a vector of
column indices, or a select helper function (e.g. \code{\link[=starts_with]{starts_with()}},
\code{\link[=ends_with]{ends_with()}}, \code{\link[=contains]{contains()}}, \code{\link[=matches]{matches()}}, \code{\link[=num_range]{num_range()}} and \code{\link[=everything]{everything()}}).}

\item{rows}{\emph{Rows to target}

\code{\link[=rows-columns]{<row-targeting expression>}} // \emph{default:} \code{everything()}

In conjunction with \code{columns}, we can specify which of their rows should
undergo formatting. The default \code{\link[=everything]{everything()}} results in all rows in
\code{columns} being formatted. Alternatively, we can supply a vector of row
captions within \code{c()}, a vector of row indices, or a select helper
function (e.g. \code{\link[=starts_with]{starts_with()}}, \code{\link[=ends_with]{ends_with()}}, \code{\link[=contains]{contains()}}, \code{\link[=matches]{matches()}},
\code{\link[=num_range]{num_range()}}, and \code{\link[=everything]{everything()}}). We can also use expressions to filter
down to the rows we need (e.g., \verb{[colname_1] > 100 & [colname_2] < 50}).}

\item{use_seps}{\emph{Use digit group separators}

\verb{scalar<logical>} // \emph{default:} \code{TRUE}

An option to use digit group separators. The type of digit group separator
is set by \code{sep_mark} and overridden if a locale ID is provided to \code{locale}.
This setting is \code{TRUE} by default.}

\item{accounting}{\emph{Use accounting style}

\verb{scalar<logical>} // \emph{default:} \code{FALSE}

An option to use accounting style for values. Normally, negative values
will be shown with a minus sign but using accounting style will instead put
any negative values in parentheses.}

\item{scale_by}{\emph{Scale values by a fixed multiplier}

\verb{scalar<numeric|integer>} // \emph{default:} \code{1}

All numeric values will be multiplied by the \code{scale_by} value before
undergoing formatting. Since the \code{default} value is \code{1}, no values will be
changed unless a different multiplier value is supplied. This value will be
ignored if using any of the \code{suffixing} options (i.e., where \code{suffixing} is
not set to \code{FALSE}).}

\item{suffixing}{\emph{Specification for large-number suffixing}

\verb{scalar<logical>|vector<character>} // \emph{default:} \code{FALSE}

The \code{suffixing} option allows us to scale and apply suffixes to larger
numbers (e.g., \code{1924000} can be transformed to \verb{2M}). This option can
accept a logical value, where \code{FALSE} (the default) will not perform this
transformation and \code{TRUE} will apply thousands (\code{K}), millions (\code{M}),
billions (\code{B}), and trillions (\code{T}) suffixes after automatic value scaling.

We can alternatively provide a character vector that serves as a
specification for which symbols are to be used for each of the value ranges.
These preferred symbols will replace the defaults (e.g.,
\code{c("k", "Ml", "Bn", "Tr")} replaces \code{"K"}, \code{"M"}, \code{"B"}, and \code{"T"}).

Including \code{NA} values in the vector will ensure that the particular range
will either not be included in the transformation (e.g.,
\code{c(NA, "M", "B", "T")} won't modify numbers at all in the thousands range)
or the range will inherit a previous suffix (e.g., with
\code{c("K", "M", NA, "T")}, all numbers in the range of millions and billions
will be in terms of millions).

Any use of \code{suffixing} (where it is not set expressly as \code{FALSE}) means
that any value provided to \code{scale_by} will be ignored.

If using \code{system = "ind"} then the default suffix set provided by
\code{suffixing = TRUE} will be the equivalent of \code{c(NA, "L", "Cr")}. This
doesn't apply suffixes to the thousands range, but does express values in
\emph{lakhs} and \emph{crores}.}

\item{pattern}{\emph{Specification of the formatting pattern}

\verb{scalar<character>} // \emph{default:} \code{"{x}"}

A formatting pattern that allows for decoration of the formatted value. The
formatted value is represented by the \code{{x}} (which can be used multiple
times, if needed) and all other characters will be interpreted as string
literals.}

\item{sep_mark}{\emph{Separator mark for digit grouping}

\verb{scalar<character>} // \emph{default:} \code{","}

The string to use as a separator between groups of digits. For example,
using \code{sep_mark = ","} with a value of \code{1000} would result in a formatted
value of \code{"1,000"}. This argument is ignored if a \code{locale} is supplied
(i.e., is not \code{NULL}).}

\item{force_sign}{\emph{Forcing the display of a positive sign}

\verb{scalar<logical>} // \emph{default:} \code{FALSE}

Should the positive sign be shown for positive values (effectively showing
a sign for all values except zero)? If so, use \code{TRUE} for this option. The
default is \code{FALSE}, where only negative numbers will display a minus sign.
This option is disregarded when using accounting notation with
\code{accounting = TRUE}.}

\item{min_sep_threshold}{\emph{Minimum digit threshold for grouping separators}

\code{scalar<numeric|integer>(val>=1)} // \emph{default:} \code{1}

The minimum number of digits required in the integer part of a number for
grouping separators to be applied. This parameter determines when digit
grouping begins based on the magnitude of values. The value \code{1} (the
default) applies separators starting at 4-digit numbers (e.g., \verb{1,000} and
above). A value of \code{2} starts grouping at 5-digit numbers (\verb{10,000} and
above), while \code{3} begins at 6-digit numbers (\verb{100,000} and above).}

\item{system}{\emph{Numbering system for grouping separators}

\verb{singl-kw:[intl|ind]} // \emph{default:} \code{"intl"}

The international numbering system (keyword: \code{"intl"}) is widely used and
its grouping separators (i.e., \code{sep_mark}) are always separated by three
digits. The alternative system, the Indian numbering system (keyword:
\code{"ind"}), uses grouping separators that correspond to thousand, lakh,
crore, and higher quantities.}

\item{locale}{\emph{Locale identifier}

\verb{scalar<character>} // \emph{default:} \code{NULL} (\code{optional})

An optional locale identifier that can be used for formatting values
according to the locale's rules. Examples include \code{"en"} for English (United
States) and \code{"fr"} for French (France). We can call \code{\link[=info_locales]{info_locales()}} for a
useful reference for all of the locales that are supported. A locale ID can
be also set in the initial \code{\link[=gt]{gt()}} function call (where it would be used
automatically by any function with a \code{locale} argument) but a \code{locale}
value provided here will override that global locale.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
With numeric values in a \strong{gt} table, we can perform number-based
formatting so that the targeted values are always rendered as integer values.
We can have fine control over integer formatting with the following options:
\itemize{
\item digit grouping separators: options to enable/disable digit separators
and provide a choice of separator symbol
\item scaling: we can choose to scale targeted values by a multiplier value
\item large-number suffixing: larger figures (thousands, millions, etc.) can
be autoscaled and decorated with the appropriate suffixes
\item pattern: option to use a text pattern for decoration of the formatted
values
\item locale-based formatting: providing a locale ID will result in number
formatting specific to the chosen locale
}
}
\section{Compatibility of formatting function with data values}{


\code{fmt_integer()} is compatible with body cells that are of the \code{"numeric"} or
\code{"integer"} types. Any other types of body cells are ignored during
formatting. This is to say that cells of incompatible data types may be
targeted, but there will be no attempt to format them.
}

\section{Compatibility of arguments with the \code{from_column()} helper function}{


\code{\link[=from_column]{from_column()}} can be used with certain arguments of \code{fmt_integer()} to
obtain varying parameter values from a specified column within the table.
This means that each row could be formatted a little bit differently. These
arguments provide support for \code{\link[=from_column]{from_column()}}:
\itemize{
\item \code{use_seps}
\item \code{accounting}
\item \code{scale_by}
\item \code{suffixing}
\item \code{pattern}
\item \code{sep_mark}
\item \code{force_sign}
\item \code{min_sep_threshold}
\item \code{system}
\item \code{locale}
}

Please note that for all of the aforementioned arguments, a \code{\link[=from_column]{from_column()}}
call needs to reference a column that has data of the correct type (this is
different for each argument). Additional columns for parameter values can be
generated with \code{\link[=cols_add]{cols_add()}} (if not already present). Columns that contain
parameter data can also be hidden from final display with \code{\link[=cols_hide]{cols_hide()}}.
Finally, there is no limitation to how many arguments the \code{\link[=from_column]{from_column()}}
helper is applied so long as the arguments belong to this closed set.
}

\section{Adapting output to a specific \code{locale}}{


This formatting function can adapt outputs according to a provided \code{locale}
value. Examples include \code{"en"} for English (United States) and \code{"fr"} for
French (France). The use of a valid locale ID here means separator marks will
be correct for the given locale. Should any value be provided in \code{sep_mark},
it will be overridden by the locale's preferred value.

Note that a \code{locale} value provided here will override any global locale
setting performed in \code{\link[=gt]{gt()}}'s own \code{locale} argument (it is settable there as
a value received by all other functions that have a \code{locale} argument). As a
useful reference on which locales are supported, we can call \code{\link[=info_locales]{info_locales()}}
to view an info table.
}

\section{Examples}{


For this example, we'll use two columns from the \code{\link{exibble}} dataset and
create a simple \strong{gt} table. With \code{fmt_integer()}, we'll format the \code{num}
column as integer values having no digit separators (with the
\code{use_seps = FALSE} option).

\if{html}{\out{<div class="sourceCode r">}}\preformatted{exibble |>
  dplyr::select(num, char) |>
  gt() |>
  fmt_integer(use_seps = FALSE)
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_fmt_integer_1.png" alt="This image of a table was generated from the first code example in the `fmt_integer()` help file." style="width:100\%;">
}}

Let's use a modified version of the \code{\link{countrypops}} dataset to create a
\strong{gt} table with row labels. We will format all numeric columns with
\code{fmt_integer()} and scale all values by \code{1 / 1E6}, giving us integer values
representing millions of people. We can make clear what the values represent
with an informative spanner label via \code{\link[=tab_spanner]{tab_spanner()}}.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{countrypops |>
  dplyr::select(country_code_3, year, population) |>
  dplyr::filter(country_code_3 \%in\% c("CHN", "IND", "USA", "PAK", "IDN")) |>
  dplyr::filter(year > 1975 & year \%\% 5 == 0) |>
  tidyr::pivot_wider(names_from = year, values_from = population) |>
  dplyr::arrange(desc(`2015`)) |>
  gt(rowname_col = "country_code_3") |>
  fmt_integer(scale_by = 1 / 1E6) |>
  tab_spanner(label = "Millions of People", columns = everything())
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_fmt_integer_2.png" alt="This image of a table was generated from the second code example in the `fmt_integer()` help file." style="width:100\%;">
}}

Using a subset of the \code{\link{towny}} dataset, we can do interesting things with
integer values. Through \code{\link[=cols_add]{cols_add()}} we'll add the \code{difference} column (which
calculates the difference between 2021 and 2001 populations). All numeric
values will be formatted with a first pass of \code{fmt_integer()}; a second pass
of \code{fmt_integer()} focuses on the \code{difference} column and here we use the
\code{force_sign = TRUE} option to draw attention to positive and negative
difference values.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{towny |>
  dplyr::select(name, population_2001, population_2021) |>
  dplyr::slice_tail(n = 10) |>
  gt() |>
  cols_add(difference = population_2021 - population_2001) |>
  fmt_integer() |>
  fmt_integer(columns = difference, force_sign = TRUE) |>
  cols_label_with(fn = function(x) gsub("population_", "", x)) |>
  tab_style(
    style = cell_fill(color = "gray90"),
    locations = cells_body(columns = difference)
  )
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_fmt_integer_3.png" alt="This image of a table was generated from the third code example in the `fmt_integer()` help file." style="width:100\%;">
}}
}

\section{Function ID}{

3-2
}

\section{Function Introduced}{

\code{v0.3.1} (August 9, 2021)
}

\seealso{
Format number with decimal values: \code{\link[=fmt_number]{fmt_number()}}

The vector-formatting version of this function: \code{\link[=vec_fmt_integer]{vec_fmt_integer()}}

Other data formatting functions: 
\code{\link{data_color}()},
\code{\link{fmt}()},
\code{\link{fmt_auto}()},
\code{\link{fmt_bins}()},
\code{\link{fmt_bytes}()},
\code{\link{fmt_chem}()},
\code{\link{fmt_country}()},
\code{\link{fmt_currency}()},
\code{\link{fmt_date}()},
\code{\link{fmt_datetime}()},
\code{\link{fmt_duration}()},
\code{\link{fmt_email}()},
\code{\link{fmt_engineering}()},
\code{\link{fmt_flag}()},
\code{\link{fmt_fraction}()},
\code{\link{fmt_icon}()},
\code{\link{fmt_image}()},
\code{\link{fmt_index}()},
\code{\link{fmt_markdown}()},
\code{\link{fmt_number}()},
\code{\link{fmt_number_si}()},
\code{\link{fmt_partsper}()},
\code{\link{fmt_passthrough}()},
\code{\link{fmt_percent}()},
\code{\link{fmt_roman}()},
\code{\link{fmt_scientific}()},
\code{\link{fmt_spelled_num}()},
\code{\link{fmt_tf}()},
\code{\link{fmt_time}()},
\code{\link{fmt_units}()},
\code{\link{fmt_url}()},
\code{\link{sub_large_vals}()},
\code{\link{sub_missing}()},
\code{\link{sub_small_vals}()},
\code{\link{sub_values}()},
\code{\link{sub_zero}()}
}
\concept{data formatting functions}
