% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save_functions.R
\name{save_plot}
\alias{save_plot}
\title{Save a Single Plot}
\usage{
save_plot(
  plot,
  filename = "plot",
  format = c("png", "pdf", "jpg"),
  width = 8,
  height = 6,
  dpi = 300
)
}
\arguments{
\item{plot}{A ggplot2 object.}

\item{filename}{Name of the file to save, with or without extension.}

\item{format}{Output format. One of "png", "pdf", or "jpg".}

\item{width}{Width of the saved plot in inches.}

\item{height}{Height of the saved plot in inches.}

\item{dpi}{Resolution of the plot in dots per inch (default is 300).}
}
\value{
Saves the file to a temporary directory (if no path is given).
}
\description{
Saves a ggplot2 plot to a file in PNG, PDF, or JPG format.
}
\examples{
\donttest{
library(ggplot2)
p <- ggplot(mtcars, aes(x = wt, y = mpg)) +
  geom_point()
save_plot(p, filename = file.path(tempdir(), "scatterplot"), format = "png")
}
}
