% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/capture.R
\name{capture}
\alias{capture}
\title{Capture Evaluation Side Effects}
\usage{
capture(expr)
}
\arguments{
\item{expr}{An R expression to evaluate. The expression is captured using
\code{substitute()} to retain its code form before evaluation.}
}
\value{
A list with the following components:
\describe{
  \item{value}{The result of evaluating \code{expr}.}
  \item{output}{A character vector with the printed output produced during evaluation.}
  \item{messages}{A character vector with any messages generated during evaluation.}
  \item{warnings}{A character vector with any warnings produced during evaluation.}
  \item{error}{A character string with the error message if an error occurred; otherwise \code{NULL}.}
}
}
\description{
This function evaluates an R expression while capturing its printed output,
messages, warnings, and errors. It returns a list containing the result of
the evaluation along with all the captured texts.
}
\details{
The function uses \code{withCallingHandlers()} and \code{tryCatch()} to capture
side effects of evaluating the expression. Printed output is captured using
\code{capture.output()}. Warnings and messages are intercepted and their default
display is suppressed using \code{invokeRestart("muffleWarning")} and
\code{invokeRestart("muffleMessage")}, respectively. If an error occurs, its
message is stored and \code{NULL} is returned as the value.
}
\examples{
\dontrun{
  # Example: Capturing output, messages, warnings, and errors
  captured <- capture({
    print("Hello, world!")
    message("This is a message.")
    warning("This is a warning.")
    42  # Final value returned
  })

  # Display the captured components
  print(captured$output)    # Printed output
  print(captured$messages)   # Messages
  print(captured$warnings)   # Warnings
  print(captured$error)      # Error message (if any)
  print(captured$value)      # The evaluated result (42 in this example)
}

}
