% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/h3-hierarchical.R
\name{get_parents}
\alias{get_parents}
\alias{get_children}
\alias{get_children_count}
\alias{get_children_center}
\alias{get_children_position}
\alias{get_children_at}
\title{Hierarchical H3 Grid Functions}
\usage{
get_parents(x, resolution)

get_children(x, resolution)

get_children_count(x, resolution)

get_children_center(x, resolution)

get_children_position(x, resolution)

get_children_at(x, position, resolution)
}
\arguments{
\item{x}{an \code{H3} vector.}

\item{resolution}{a scalar integer representing the grid resolution in the range [0, 15].}

\item{position}{the integer position in the ordered set of cells.}
}
\value{
See details.
}
\description{
Functions used to traverse the hierarchy of H3 grids.
}
\details{
\itemize{
\item \code{get_parents()}: returns the parent cells for an \code{H3} vector at a given resolution. Errors if the resolution is smaller than the provided cell.
\item \code{get_children()}: returns a list of \code{H3} vectors containing the children of each H3 cell at a specified resolution. If the resolution is greater than the cell's resolution an empty vector is returned.
\item \code{get_children_count()}: returns an integer vector containing the number of children for each cell at the specified resolution.
\item \code{get_children_center()}: returns the middle child (center child) for all children of an H3 cell at a specified resolution as an \code{H3} vector.
\item \code{get_children_position()}: returns the position of the observed H3 cell in an ordered list of all children as a child of a higher resolution cell (PR for clearer language welcome).
\item \code{get_children_at()}: returns the child of each H3 cell at a specified resolution based on its position in an ordered list (PR for clearer language welcome).
}
}
\examples{
h3_strs <- c("841f91dffffffff", "841fb59ffffffff")
h3 <- h3_from_strings(h3_strs)

get_parents(h3, 3)
get_children(h3, 5)
get_children_count(h3, 6)
get_children_position(h3, 3)
get_children_at(h3, 999, 10)
}
