% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/harbinger_utils.R
\name{harutils}
\alias{harutils}
\title{Harbinger Utilities}
\usage{
harutils()
}
\value{
A \code{harutils} object exposing the helper functions.
}
\description{
Utility object that groups common distance measures, threshold heuristics,
and outlier grouping rules used by Harbinger detectors.
}
\details{
Provided helpers include:
\itemize{
\item L1 and L2 distance aggregations over vectors or rows of matrices/data frames.
\item Thresholding heuristics: boxplot-based (IQR), Gaussian 3-sigma, and a ratio-based rule.
\item Grouping strategies for contiguous outliers: keep first index or keep highest-magnitude index.
\item Optional fuzzification over detections to propagate influence within a tolerance window.
}

These utilities centralize common tasks and ensure consistent behavior across detectors.
}
\examples{
# Basic usage of utilities
utils <- harutils()

# Compute L2 distance on residuals
res <- c(0.1, -0.5, 1.2, -0.3)
d2 <- utils$har_distance_l2(res)
print(d2)

# Apply 3-sigma outlier rule and keep only first index of contiguous runs
idx <- utils$har_outliers_gaussian(d2)
flags <- utils$har_outliers_checks_firstgroup(idx, d2)
print(which(flags))

}
\references{
\itemize{
\item Tukey JW (1977). Exploratory Data Analysis. Addison-Wesley. (boxplot/IQR heuristic)
\item Shewhart WA (1931). Economic Control of Quality of Manufactured Product. D. Van Nostrand. (three-sigma rule)
\item Silva, E. P., Balbi, H., Pacitti, E., Porto, F., Santos, J., Ogasawara, E. Cutoff
Frequency Adjustment for FFT-Based Anomaly Detectors. In: Simpósio Brasileiro de
Banco de Dados (SBBD). SBC, 14 Oct. 2024. doi:10.5753/sbbd.2024.243319
}
}
