% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dep_graph.R
\name{plot_deps_graph}
\alias{plot_deps_graph}
\title{Plot dependency graph}
\usage{
plot_deps_graph(
  pkg,
  dep_type = c("depends", "imports", "linkingto"),
  pak_res = NULL,
  info_method = "pak",
  n_iter = 100,
  init = "mds",
  gg = FALSE,
  lwd = 1,
  cex = 1,
  pad_h = 0.09,
  pad_w = 0.07,
  arw = 1,
  legend_loc = "topright",
  ...
)
}
\arguments{
\item{pkg}{package string passed to \code{\link[pak:pkg_deps]{pak::pkg_deps}}}

\item{dep_type}{type(s) of dependencies to look up. Valid values are
\code{c("depends", "imports", "linkingto")}}

\item{pak_res}{a pre-computed result from
\code{\link[pak:pkg_deps]{pak::pkg_deps}}}

\item{info_method}{either "pak" or "tools". The latter will use
\code{\link[tools:package_dependencies]{tools::package_dependencies}} to
look up package info.}

\item{n_iter}{number of iterations for stress graph layout computation}

\item{init}{how to initialize layout, MDS (default) or randomly}

\item{gg}{If true, use ggplot2 + ggraph to layout/draw the plot instead of
base graphics. Other graphical arguments below will be ignored.}

\item{lwd}{line width}

\item{cex}{text size multiplication factor (see
\code{\link[graphics:par]{graphics::par}})}

\item{pad_h}{height padding}

\item{pad_w}{width padding}

\item{arw}{factor by which to lengthen/shorten arrowheads}

\item{legend_loc}{one of "topright"/"topleft"/"bottomright"/"bottomleft"
indicating where to draw the legend}

\item{...}{other arguments passed to par()}
}
\value{
By default, no return value, called for side effect of producing a
  plot. If \code{gg = TRUE}, then a ggplot object.
}
\description{
Plot a package's dependency graph, coloring each node by the
  number of packages it depends on.
}
\details{
\code{dep_type = "suggests"} is currently not supported because
  Suggests can be cyclic.

  Pre-computing the dependency lookup with
  \code{\link[pak:pkg_deps]{pak::pkg_deps}} and passing it to the
  \code{pak_res} argument can be handy when fiddling with graphical
  parameters. Also handy to avoid hitting the bundled GitHub PAT limits used
  by pak::pkg_deps().

  The arrows and padding will be off if you resize the graphics window with
  the base graphics version. Either set \code{gg=TRUE} or set your desired
  graphics device size, then re-run your command.

  The layout in the base graphics version is initialized with a bit of random
  jitter. If you want to tweak it change the random seed and try again.

  Random layout initialization only applies to base graphics when used, and
  typically looks worse than MDS initialization. Generally only useful if the
  MDS layout happens to overlap the legend or something.
}
\examples{
plot_deps_graph("ggplot2", pak_res = pkg_deps_ex$ggplot2)
# ^ ggplot2 has a moderate number of dependencies

plot_deps_graph("data.table", pak_res = pkg_deps_ex$data.table)
# ^ data.table has only one

# The `pak_res` arguments here are pre-computed results to avoid internet
# access while running the examples on CRAN's servers. They aren't required.
}
\seealso{
\code{\link{uniq_pkg_deps}}
}
