% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correctHeap.R
\name{correctSingleHeap}
\alias{correctSingleHeap}
\title{Correct a Single Age Heap}
\usage{
correctSingleHeap(
  x,
  heap,
  before = 2,
  after = 2,
  method = "lnorm",
  fixed = NULL,
  seed = NULL,
  na.action = "omit",
  verbose = FALSE,
  sd = NULL
)
}
\arguments{
\item{x}{numeric vector representing ages (typically integers).}

\item{heap}{numeric value specifying the age for which heaping should
be corrected. Must be present in \code{x}.}

\item{before}{numeric value specifying the number of years before
the heap to use as the lower bound for replacement values.
Will be rounded to an integer. Default is 2.}

\item{after}{numeric value specifying the number of years after
the heap to use as the upper bound for replacement values.
Will be rounded to an integer. Default is 2.}

\item{method}{character string specifying the distribution used for correction:
\describe{
  \item{\code{"lnorm"}}{truncated log-normal distribution (default).
    Parameters are estimated from the input data.}
  \item{\code{"norm"}}{truncated normal distribution.
    Parameters are estimated from the input data.}
  \item{\code{"unif"}}{uniform distribution within the truncation bounds.}
  \item{\code{"kernel"}}{kernel density estimation for nonparametric sampling.}
}}

\item{fixed}{numeric vector of indices indicating observations that should
not be changed. Useful for preserving known accurate values.}

\item{seed}{optional integer for random seed to ensure reproducibility.}

\item{na.action}{character string specifying how to handle \code{NA} values:
\code{"omit"} (default) or \code{"fail"}.}

\item{verbose}{logical. If \code{TRUE}, return diagnostic information.}

\item{sd}{optional numeric value for standard deviation when \code{method = "norm"}.}
}
\value{
A numeric vector of the same length as \code{x} with the specified
  heap corrected, or a list with diagnostics if \code{verbose = TRUE}.
}
\description{
While \code{\link{correctHeaps}} corrects regular heaping patterns,
this function allows correction of a single specific heap value.
This is useful when heaping occurs at irregular intervals or when
only a particular age shows excessive heaping.
}
\details{
Correct a specific age heap in a vector containing ages.
}
\examples{
# Create artificial age data
set.seed(123)
age <- rlnorm(10000, meanlog = 2.466869, sdlog = 1.652772)
age <- round(age[age < 93])

# Artificially introduce a heap at age 23
age23 <- c(age, rep(23, length = sum(age == 23)))

# Correct with reproducible results
age23_corrected <- correctSingleHeap(age23, heap = 23, before = 5, after = 5,
                                     method = "lnorm", seed = 42)

# Get diagnostic information
result <- correctSingleHeap(age23, heap = 23, before = 5, after = 5,
                            verbose = TRUE, seed = 42)
print(result$n_changed)
}
\seealso{
\code{\link{correctHeaps}} for correcting regular heaping patterns.

Other heaping correction: 
\code{\link{correctHeaps}()}
}
\author{
Matthias Templ, Bernhard Meindl
}
\concept{heaping correction}
