% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataHandling.R
\name{selectExchange}
\alias{selectExchange}
\title{Retain only data from a single stock exchange}
\usage{
selectExchange(data, exch = "N")
}
\arguments{
\item{data}{an \code{xts} or \code{data.table} object containing the time series data. 
The object should have a column "EX", indicating the exchange by its symbol.}

\item{exch}{The (vector of) symbol(s) of the stock exchange(s) that should be selected.
By default the NYSE is chosen (\code{exch = "N"}). Other exchange symbols are:
\itemize{
\item A: AMEX
\item N: NYSE
\item B: Boston
\item P: Arca
\item C: NSX
\item T/Q: NASDAQ
\item D: NASD ADF and TRF
\item X: Philadelphia
\item I: ISE
\item M: Chicago
\item W: CBOE
\item Z: BATS
}}
}
\value{
\code{xts} or \code{data.table} object depending on input.
}
\description{
Filter raw trade data to only contain specified exchanges
}
\author{
Jonathan Cornelissen, Kris Boudt, Onno Kleen, and Emil Sjoerup.
}
\keyword{cleaning}
