% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_qualite_eau_potable.R
\name{get_qualite_eau_potable_communes_udi}
\alias{get_qualite_eau_potable_communes_udi}
\alias{get_qualite_eau_potable_resultats_dis}
\title{Retrieve data from API "Qualité de l'eau potable"}
\usage{
get_qualite_eau_potable_communes_udi(...)

get_qualite_eau_potable_resultats_dis(...)
}
\arguments{
\item{...}{parameters of the queries and their values in the format
\verb{Param1_Name = "Param1 value", Param2_Name = "Param2 value"}, use the
function \link{list_params} for a list of the available filter parameters
for a given API endpoint and see the API documentation for their description}
}
\value{
A \link[tibble:tibble]{tibble::tibble} with one row by record and one column by field.
}
\description{
Results of the sanitary control of the distributed water commune by commune:
samples and results of the analyses carried out within the framework of the
regulatory sanitary control on the distribution units or the installations
directly upstream, and links between communes and distribution units.
The elements made available in this dataset correspond to a compilation of
analysis bulletins published online, commune by commune, on the website of
the Ministry of Health: \url{https://sante.gouv.fr/sante-et-environnement/eaux/eau}

Available endpoints are:
\itemize{
\item \code{get_qualite_eau_potable_communes_udi} retrieves links between "UDI"
(Distribution units or networks) and communes
\item \code{get_qualite_eau_potable_resultats_dis} retrieves samples, analysis results
and sanitary conclusions from the sanitary control of the distributed water
commune by commune
}

See the API documentation for available filter parameters: \url{https://hubeau.eaufrance.fr/page/api-qualite-eau-potable}
}
\examples{
\dontrun{
# List of available filter parameters on 'get_qualite_eau_potable_communes_udi'
list_params("qualite_eau_potable", "communes_udi")

# List of UDIs available in 2022 at Grabels (INSEE code 34116)
get_qualite_eau_potable_communes_udi(annee = 2022, code_commune = 34116)

# List of available filter parameters on 'get_qualite_eau_potable_resultats_dis'
list_params("qualite_eau_potable", "resultats_dis")

# Get results of analysis realised at Grabels in 2022
get_qualite_eau_potable_resultats_dis(code_commune = 34116,
                                      date_min_prelevement = "2000-01-01",
                                      date_max_prelevement = "2022-12-31")
}
}
