\name{constructor}
\alias{constructor}
\alias{constructors}
\alias{constructor_2020}
\alias{constructor_2020_maxp}
\alias{constructor_table_2020}
\alias{constructor_2020_table}
\alias{constructor_2021}
\alias{constructor_2021_maxp}
\alias{constructor_table_2021}
\alias{constructor_2021_table}
\docType{data}
\title{Formula 1 dataset: the constructors' championship}
\description{Race results from 2017 Formula One constructors' Championship}
\usage{
data(constructor)
}
\format{A \code{hyper3} object that gives a likelihood function}
\details{

The Constructors championship runs parallel to the Formula 1 drivers'
championship.  The package currently includes data from 2020 and 2021; the 
following text applies to both years.  I will add more years eventually.

Object \code{constructor_2021_table} is a dataframe, taken from
Wikipedia, with rows corresponding to performance of a constructor.
Each constructor fields two cars in each race; the identity of the
driver is not important in this context (and indeed may change as the
season progresses).  The first column is the name of the constructor,
the next 22 columns show the ranks of the constructors' cars, and the
final one is the points awarded.  At each venue, the constructor's best
performance is listed first.  The constructors' names change quite
frequently (e.g. \dQuote{Red Bull Racing-TAG Heuer} raced 2016,2017, and
2018; \dQuote{Red Bull Racing-Honda} raced 2019, 2020, and 2021.  I am
not sure whether to treat these as separate entities or not; file
\code{inst/constructor_names.txt} gives a dataframe of team names and
years they competed (not currently part of the package).  The row names
of the dataframe cannot be the constructors because these are not
unique.

Object \code{constructor_2021_maxp} gives the maximum likelihood
estimate for the constructors' strengths. 
The corresponding \code{hyper3} likelihood function
\code{constructor_2021} is produced by \code{ordertable2supp3()}.

These objects can be generated by running script \code{inst/race3.Rmd},
which includes some further discussion and technical documentation, and
creates file \code{constructor.rda} which resides in the \code{data/}
directory.

}
\references{

  Wikipedia contributors. (2022, April 14). 2021 Formula One World
  Championship. In _Wikipedia, The Free Encyclopedia_. Retrieved 05:16,
  April 17, 2022, from
  \url{https://en.wikipedia.org/w/index.php?title=2021_Formula_One_World_Championship&oldid=1082745216}
 
  }
\seealso{\code{\link{formula1}}}
\examples{
dotchart(constructor_2021_maxp)
}
