#' Auxiliary Internal Functions
#' 
#'
#' @param x Matrix with two columns: candidate ID (`candidate`) and utility (`dist`)
#' @param n Number of candidates to be nominated
#' @param rank Boolean: should nominated candidates be ranked? Defaults to `TRUE`.
#' 

find_best_candidates <- function(x, n, rank = TRUE)
{
  if(nrow(x) > n){ #More candidates than spots?
    best <- order(x$dist)[1:n]
    nom <- rep(0, length(x$dist))
    if(rank){
      nom[best] <- 1:length(best)
    } else {
      nom[best] <- 1
    }
    return(cbind(nom, as.numeric(x$candidate)))
  } else { #Fewer candidates than spots
    if(rank){
      nom <- 1:nrow(x)
    } else {
      nom <- 1
    }
    return(cbind(nom, as.numeric(x$candidate)[order(x$dist)]))
  }
}