% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io_immundata_write.R
\name{write_immundata}
\alias{write_immundata}
\title{Save ImmunData to disk}
\usage{
write_immundata(idata, output_folder)
}
\arguments{
\item{idata}{The \code{ImmunData} object to save. Must be an R6 object of class
\code{ImmunData} containing at least the \verb{$annotations} table and schema information
(\verb{$schema_receptor}, optionally \verb{$schema_repertoire}).}

\item{output_folder}{Character(1). Path to the directory where the output files
will be written. If the directory does not exist, it will be created
recursively.}
}
\value{
Invisibly returns the input \code{idata} object, saved to disk.
In other words, this allows you to create snapshots of the data in the
\code{output_folder}. Mind that by saving the object, you execute all the
stored computations, so this operations can take longer than expected.
Read more about snapshots on our website in the \href{https://immunomind.github.io/docs/concepts/basics/immutability/}{"Concept" section}.
}
\description{
Serializes the essential components of an \code{ImmunData} object to disk for
efficient storage and later retrieval. It saves the core annotation data
(\code{idata$annotations}) as a compressed Parquet file and accompanying metadata
(including receptor/repertoire schemas and package version) as a JSON file
within a specified directory.
}
\details{
The function performs the following actions:
\enumerate{
\item Validates the input \code{idata} object and \code{output_folder} path.
\item Creates the \code{output_folder} if it doesn't exist.
\item Constructs a list containing metadata: \code{immundata} package version,
receptor schema (\code{idata$schema_receptor}), and repertoire schema
(\code{idata$schema_repertoire}).
\item Writes the metadata list to \code{metadata.json} within \code{output_folder}.
\item Writes the \code{idata$annotations} table (a \code{duckplyr_df} or similar) to
\code{annotations.parquet} within \code{output_folder}. Uses Zstandard compression
(\code{compression = "zstd"}, \code{compression_level = 9}) for a good balance
between file size and read/write speed.
\item Uses internal helper \code{imd_files()} to determine the standard filenames
(\code{metadata.json}, \code{annotations.parquet}).
}

The receptor data itself (if stored separately in future versions) is not
saved by this function; only the annotations linking to receptors are saved,
along with the schema needed to reconstruct/interpret them.
}
\examples{
\dontrun{
# Assume 'my_idata' is an ImmunData object created previously
# my_idata <- read_repertoires(...)

# Define an output directory
save_dir <- tempfile("saved_immundata_")

# Save the ImmunData object
write_immundata(my_idata, save_dir)

# Check the created files
list.files(save_dir) # Should show "annotations.parquet" and "metadata.json"

# Clean up
unlink(save_dir, recursive = TRUE)
}
}
\seealso{
\code{\link[=read_immundata]{read_immundata()}} for loading the saved data, \code{\link[=read_repertoires]{read_repertoires()}}
which uses this function internally, \link{ImmunData} class definition.
}
\concept{ingestion}
