% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fredholm.R
\name{fredholm_solve}
\alias{fredholm_solve}
\title{Solve a Fredholm equation of the first and second kind}
\usage{
fredholm_solve(
  k,
  f = function(x) x,
  a = -0,
  b = 1,
  num = 41L,
  smin = 0,
  smax = 1,
  snum = 41L,
  gamma = 0.001
)
}
\arguments{
\item{k}{kernel function of two time scales}

\item{f}{left hand side function with f(a)=0}

\item{a}{lower bound of the grid for the integral approximation}

\item{b}{upper bound of the grid for the integral approximation}

\item{num}{number of points for the grid of the integral approximation}

\item{smin}{lower bound of enforcement values for equation}

\item{smax}{upper bound of enforcement values for equation}

\item{snum}{number of points for the grid for the equation}

\item{gamma}{regularization parameter}
}
\value{
data-frame with evaluation points 'ygrid' and calculations 'ggrid'
}
\description{
Solve a Fredholm equation of the first and second kind
}
\examples{
# Define the kernel function
k <- function(s, t) {
    ifelse(abs(s - t) <= 3, 1 + cos(pi * (t - s) / 3), 0)
}

# Define the right-hand side function
f <- function(s) {
    sp <- abs(s)
    sp3 <- sp * pi / 3
    ((6 - sp) * (2 + cos(sp3)) + (9 / pi) * sin(sp3)) / 2
}

# Define the true solution for comparison
trueg <- function(s) {
    k(0, s)
}

# Solve the Fredholm equation
res <- fredholm_solve(
    k, f, -3, 3, 1001L,
    smin = -6, smax = 6, snum = 2001L,
    gamma = 0.01
)

# Plot the results on the same graph using base graphics
plot(
    res$ygrid, res$ggrid,
    type = "l",
    col = "blue",
    xlim = c(-3, 3),
    #ylim = c(-1, 1),
    xlab = "s",
    ylab = "g(s)",
    main = "Fredholm Equation Solution"
)
# add the true solution
lines(res$ygrid, trueg(res$ygrid), col = "red", lty = 2)
legend( 
    "topright",
    legend = c("Estimated Value", "True Value"),
    col = c("blue", "red"),
    lty = c(1, 2)
)
}
