#' Plot Method for icm_stanfit Objects
#'
#' This function provides a plot method for objects of class `icm_stanfit`.
#'
#' @param x An object of class `icm_stanfit`.
#' @param ... Additional arguments passed to the `plot_consensus` function.
#'
#' @return A plot generated by the [plot_consensus()] function.
#'
#' @examples
#' \donttest{
#' # Create minimal example data
#' df_simplex <- data.frame(
#'   x1 = c(0.3, 0.4, 0.2, 0.5),
#'   x2 = c(0.3, 0.2, 0.4, 0.2),
#'   x3 = c(0.4, 0.4, 0.4, 0.3)
#' )
#' id_person <- c(1, 1, 2, 2)
#' id_item <- c(1, 2, 1, 2)
#'
#' # Fit ICM model
#' fit <- fit_icm(df_simplex, id_person, id_item, n_chains = 1,
#'                iter_sampling = 100, iter_warmup = 100,
#'                refresh = 0)
#'
#' # Plot using S3 method
#' plot(fit)
#' }
#'
#' @seealso [plot_consensus()]
#'
#' @exportS3Method intervalpsych::plot
plot.icm_stanfit <- function(x, ...) {
  plot_consensus(x, ...)
}
