% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{build_mydata_clint}
\alias{build_mydata_clint}
\title{Build Data Object for Intrinsic Hepatic Clearance (Clint) Bayesian Model}
\usage{
build_mydata_clint(
  this.cvt,
  this.data,
  decrease.prob,
  saturate.prob,
  degrade.prob
)
}
\arguments{
\item{this.cvt}{(Data Frame) Subset of data containing all "Cvst" sample observations of one test compound.}

\item{this.data}{(Data Frame) Subset of data containing all observations of one test compound.}

\item{decrease.prob}{(Numeric) Prior probability that a chemical will decrease in
the assay.}

\item{saturate.prob}{(Numeric) Prior probability that a chemicals rate of metabolism
will decrease between 1 and 10 uM.}

\item{degrade.prob}{(Numeric) Prior probability that a chemical will be unstable
(that is, degrade abiotically) in the assay.}
}
\value{
A named list to be passed into the Bayesian model.
}
\description{
Builds a list of arguments required for JAGS from subset of level-2 data frame. 
The list is used as an argument to JAGS during level-4 processing.
}
