% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jal2grep.R
\name{jal2greg}
\alias{jal2greg}
\title{Convert Jalaali (Persian) Calendar Date to Gregorian Calendar Date}
\usage{
jal2greg(year, month, day)
}
\arguments{
\item{year}{An integer or a vector of integers representing the Jalali year(s).}

\item{month}{An integer or a vector of integers representing the Jalali month(s) (1-12).}

\item{day}{An integer or a vector of integers representing the Jalali day(s) (1-31).}
}
\value{
A `Date` object or a vector of `Date` objects representing the
corresponding Gregorian date(s). If any input value is invalid, `NA` is
returned for that entry.
}
\description{
This function converts a date from the Jalaali (Persian) calendar to the
Gregorian calendar. It supports both single date conversions and vectorized
operations for multiple dates.
}
\details{
The function first verifies that the input values are valid Jalali dates,
ensuring that:
- The `year` values are finite integers.
- The `month` values range from 1 to 12.
- The `day` values are within valid ranges (1-31), considering month-specific limits.

The conversion is performed in two steps:
1. The function determines the Gregorian start date of the given Jalaali year
   using the `jalLeap()` function. This function provides the corresponding
   Gregorian year and the day in March when the Jalaali year begins.
2. The exact Gregorian date is then calculated by adding the number of days
   elapsed since the start of the Jalaali year.
}
\examples{
# Convert a single Jalaali date to Gregorian
jal2greg(1402, 1, 1)

# Convert multiple Jalaali dates to Gregorian
jal2greg(c(1403, 1404), c(12, 1), c(30, 1))

}
\seealso{
- \link[jalcal]{jalLeap} for computing leap year information.
- \link[jalcal]{greg2jal} for converting Jalaali dates to Gregorian dates
}
