% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ttestis.h.R
\name{ttestIS}
\alias{ttestIS}
\title{Independent Samples T-Test}
\usage{
ttestIS(data, vars, group, students = TRUE, bf = FALSE,
  bfPrior = 0.707, welchs = FALSE, mann = FALSE,
  hypothesis = "different", norm = FALSE, qq = FALSE, eqv = FALSE,
  meanDiff = FALSE, ci = FALSE, ciWidth = 95, effectSize = FALSE,
  ciES = FALSE, ciWidthES = 95, desc = FALSE, plots = FALSE,
  miss = "perAnalysis", formula)
}
\arguments{
\item{data}{the data as a data frame}

\item{vars}{the dependent variables (not necessary when using a formula,
see the examples)}

\item{group}{the grouping variable with two levels (not necessary when
using a formula, see the examples)}

\item{students}{\code{TRUE} (default) or \code{FALSE}, perform Student's
t-tests}

\item{bf}{\code{TRUE} or \code{FALSE} (default), provide Bayes factors}

\item{bfPrior}{a number between 0.01 and 2 (default 0.707), the prior width
to use in calculating Bayes factors}

\item{welchs}{\code{TRUE} or \code{FALSE} (default), perform Welch's
t-tests}

\item{mann}{\code{TRUE} or \code{FALSE} (default), perform Mann-Whitney U
tests}

\item{hypothesis}{\code{'different'} (default), \code{'oneGreater'} or
\code{'twoGreater'}, the alternative hypothesis; group 1 different to group
2, group 1 greater than group 2, and group 2 greater than group 1
respectively}

\item{norm}{\code{TRUE} or \code{FALSE} (default), perform Shapiro-Wilk
tests of normality}

\item{qq}{\code{TRUE} or \code{FALSE} (default), provide Q-Q plots of
residuals}

\item{eqv}{\code{TRUE} or \code{FALSE} (default), perform Levene's tests
for homogeneity of variances}

\item{meanDiff}{\code{TRUE} or \code{FALSE} (default), provide means and
standard errors}

\item{ci}{\code{TRUE} or \code{FALSE} (default), provide confidence
intervals}

\item{ciWidth}{a number between 50 and 99.9 (default: 95), the width of
confidence intervals}

\item{effectSize}{\code{TRUE} or \code{FALSE} (default), provide effect
sizes}

\item{ciES}{\code{TRUE} or \code{FALSE} (default), provide confidence
intervals for the effect-sizes}

\item{ciWidthES}{a number between 50 and 99.9 (default: 95), the width of
confidence intervals for the effect sizes}

\item{desc}{\code{TRUE} or \code{FALSE} (default), provide descriptive
statistics}

\item{plots}{\code{TRUE} or \code{FALSE} (default), provide descriptive
plots}

\item{miss}{\code{'perAnalysis'} or \code{'listwise'}, how to handle
missing values; \code{'perAnalysis'} excludes missing values for individual
dependent variables, \code{'listwise'} excludes a row from all analyses if
one of its entries is missing.}

\item{formula}{(optional) the formula to use, see the examples}
}
\value{
A results object containing:
\tabular{llllll}{
  \code{results$ttest} \tab \tab \tab \tab \tab a table containing the t-test results \cr
  \code{results$assum$norm} \tab \tab \tab \tab \tab a table containing the normality tests \cr
  \code{results$assum$eqv} \tab \tab \tab \tab \tab a table containing the homogeneity of variances tests \cr
  \code{results$desc} \tab \tab \tab \tab \tab a table containing the group descriptives \cr
  \code{results$plots} \tab \tab \tab \tab \tab an array of groups of plots \cr
}

Tables can be converted to data frames with \code{asDF} or \code{\link{as.data.frame}}. For example:

\code{results$ttest$asDF}

\code{as.data.frame(results$ttest)}
}
\description{
The Student's Independent samples t-test (sometimes called a two-samples
t-test) is used to test the null hypothesis that two groups have the
same mean. A low p-value suggests that the null hypothesis is not true,
and therefore the group means are different.
}
\details{
The Student's independent t-test assumes that the data from each group
are from a normal distribution, and that the variances of these groups
are equal. If unwilling to assume the groups have equal variances, the
Welch's t-test can be used in it's place. If one is additionally
unwilling to assume the data from each group are from a normal
distribution, the non-parametric Mann-Whitney U test can be used instead
(However, note that the Mann-Whitney U test has a slightly different
null hypothesis; that the distributions of each group is equal).
}
\examples{
data('ToothGrowth')

ttestIS(formula = len ~ supp, data = ToothGrowth)

#
#  INDEPENDENT SAMPLES T-TEST
#
#  Independent Samples T-Test
#  ----------------------------------------------------
#                          statistic    df      p
#  ----------------------------------------------------
#    len    Student's t         1.92    58.0    0.060
#  ----------------------------------------------------
#

}
