% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jobqueue.r
\name{jobqueue}
\alias{jobqueue}
\title{Assigns Jobs to Workers}
\usage{
jobqueue(
  globals = NULL,
  packages = NULL,
  namespace = NULL,
  init = NULL,
  max_cpus = availableCores(),
  workers = ceiling(max_cpus * 1.2),
  timeout = NULL,
  hooks = NULL,
  reformat = NULL,
  signal = FALSE,
  cpus = 1L,
  stop_id = NULL,
  copy_id = NULL
)
}
\arguments{
\item{globals}{A named list of variables that all \verb{<job>$expr}s will have
access to. Alternatively, an object that can be coerced to a named
list with \code{as.list()}, e.g. named vector, data.frame, or environment.}

\item{packages}{Character vector of package names to load on
\code{\link[=worker_class]{workers}}.}

\item{namespace}{The name of a package to attach to the
\code{\link[=worker_class]{worker's}} environment.}

\item{init}{A call or R expression wrapped in curly braces to evaluate on
each \code{\link[=worker_class]{worker}} just once, immediately after start-up.
Will have access to variables defined by \code{globals} and assets from
\code{packages} and \code{namespace}. Returned value is ignored.}

\item{max_cpus}{Total number of CPU cores that can be reserved by all
running \code{\link[=job_class]{jobs}} (\verb{sum(<job>$cpus)}). Does not enforce
limits on actual CPU utilization.}

\item{workers}{How many background \code{\link[=worker_class]{worker}} processes to
start. Set to more than \code{max_cpus} to enable standby
\code{\link[=worker_class]{workers}} to quickly swap out with
\code{\link[=worker_class]{workers}} that need to restart.}

\item{timeout}{A named numeric vector indicating the maximum number of
seconds allowed for each state the \code{\link[=job_class]{job}} passes through,
or 'total' to apply a single timeout from 'submitted' to 'done'. Can
also limit the 'starting' state for \code{\link[=worker_class]{workers}}. A
\verb{function (job)} can be used in place of a number.
Example: \code{timeout = c(total = 2.5, running = 1)}.
See \code{vignette('stops')}.}

\item{hooks}{A named list of functions to run when the \code{\link[=job_class]{job}}
state changes, of the form
\code{hooks = list(created = function (worker) {...})}. Or a
\verb{function (job)} that returns the same. Names of
\code{\link[=worker_class]{worker}} hooks are typically \code{'created'},
\code{'submitted'}, \code{'queued'}, \code{'dispatched'}, \code{'starting'}, \code{'running'},
\code{'done'}, or \code{'*'} (duplicates okay). See \code{vignette('hooks')}.}

\item{reformat}{Set \verb{reformat = function (job)} to define what
\verb{<job>$result} should return. The default, \code{reformat = NULL} passes
\verb{<job>$output} to \verb{<job>$result} unchanged.
See \code{vignette('results')}.}

\item{signal}{Should calling \verb{<job>$result} signal on condition objects?
When \code{FALSE}, \verb{<job>$result} will return the object without
taking additional action. Setting to \code{TRUE} or a character vector of
condition classes, e.g. \code{c('interrupt', 'error', 'warning')}, will
cause the equivalent of \verb{stop(<condition>)} to be called when those
conditions are produced. Alternatively, a \verb{function (job)} that
returns \code{TRUE} or \code{FALSE}. See \code{vignette('results')}.}

\item{cpus}{The default number of CPU cores per \code{\link[=job_class]{job}}. Or a
\verb{function (job)} that returns the number of CPU cores to reserve for
a given \code{\link[=job_class]{job}}. Used to limit the number of
\code{\link[=job_class]{jobs}} running simultaneously to respect
\verb{<jobqueue>$max_cpus}. Does not prevent a \code{\link[=job_class]{job}} from
using more CPUs than reserved.}

\item{stop_id}{If an existing \code{\link[=job_class]{job}} in the
\code{\link[=jobqueue_class]{jobqueue}} has the same \code{stop_id}, that
\code{\link[=job_class]{job}} will be stopped and return an 'interrupt'
condition object as its result. \code{stop_id} can also be a
\verb{function (job)} that returns the \code{stop_id} to assign to a given
\code{\link[=job_class]{job}}. A \code{stop_id} of \code{NULL} disables this feature.
See \code{vignette('stops')}.}

\item{copy_id}{If an existing \code{\link[=job_class]{job}} in the
\code{\link[=jobqueue_class]{jobqueue}} has the same \code{copy_id}, the newly
submitted \code{\link[=job_class]{job}} will become a "proxy" for that earlier
\code{\link[=job_class]{job}}, returning whatever result the earlier
\code{\link[=job_class]{job}} returns. \code{copy_id} can also be a \verb{function (job)}
that returns the \code{copy_id} to assign to a given \code{\link[=job_class]{job}}.
A \code{copy_id} of \code{NULL} disables this feature. See \code{vignette('stops')}.}
}
\value{
A \code{\link[=jobqueue_class]{jobqueue}} object.
}
\description{
Jobs go in. Results come out.
}
\examples{
\dontshow{if (! jobqueue:::is_cran_check()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

jq <- jobqueue(globals = list(N = 42), workers = 2)
print(jq)

job <- jq$run({ paste("N is", N) })
job$result

jq$stop()
\dontshow{\}) # examplesIf}
}
