% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_Unif.R
\name{Unif}
\alias{Unif}
\alias{d,Unif,numeric-method}
\alias{p,Unif,numeric-method}
\alias{qn,Unif,numeric-method}
\alias{r,Unif,numeric-method}
\alias{mean,Unif-method}
\alias{median,Unif-method}
\alias{mode,Unif-method}
\alias{var,Unif-method}
\alias{sd,Unif-method}
\alias{skew,Unif-method}
\alias{kurt,Unif-method}
\alias{entro,Unif-method}
\alias{llunif}
\alias{ll,Unif,numeric-method}
\alias{eunif}
\alias{mle,Unif,numeric-method}
\alias{me,Unif,numeric-method}
\title{Uniform Distribution}
\usage{
Unif(min = 0, max = 1)

\S4method{d}{Unif,numeric}(distr, x, log = FALSE)

\S4method{p}{Unif,numeric}(distr, q, lower.tail = TRUE, log.p = FALSE)

\S4method{qn}{Unif,numeric}(distr, p, lower.tail = TRUE, log.p = FALSE)

\S4method{r}{Unif,numeric}(distr, n)

\S4method{mean}{Unif}(x)

\S4method{median}{Unif}(x)

\S4method{mode}{Unif}(x)

\S4method{var}{Unif}(x)

\S4method{sd}{Unif}(x)

\S4method{skew}{Unif}(x)

\S4method{kurt}{Unif}(x)

\S4method{entro}{Unif}(x)

llunif(x, min, max)

\S4method{ll}{Unif,numeric}(distr, x)

eunif(x, type = "mle", ...)

\S4method{mle}{Unif,numeric}(distr, x, na.rm = FALSE)

\S4method{me}{Unif,numeric}(distr, x, na.rm = FALSE)
}
\arguments{
\item{min, max}{numeric. The distribution parameters.}

\item{distr}{an object of class \code{Unif}.}

\item{x}{For the density function, \code{x} is a numeric vector of quantiles. For
the moments functions, \code{x} is an object of class \code{Unif}. For the
log-likelihood and the estimation functions, \code{x} is the sample of
observations.}

\item{log, log.p}{logical. Should the logarithm of the probability be
returned?}

\item{q}{numeric. Vector of quantiles.}

\item{lower.tail}{logical. If TRUE (default), probabilities are
\eqn{P(X \leq x)}, otherwise \eqn{P(X > x)}.}

\item{p}{numeric. Vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1}, the length is taken to
be the number required.}

\item{type}{character, case ignored. The estimator type (mle or me).}

\item{...}{extra arguments.}

\item{na.rm}{logical. Should the \code{NA} values be removed?}
}
\value{
Each type of function returns a different type of object:
\itemize{
\item Distribution Functions: When supplied with one argument (\code{distr}), the
\code{d()}, \code{p()}, \code{q()}, \code{r()}, \code{ll()} functions return the density, cumulative
probability, quantile, random sample generator, and log-likelihood functions,
respectively. When supplied with both arguments (\code{distr} and \code{x}), they
evaluate the aforementioned functions directly.
\item Moments: Returns a numeric, either vector or matrix depending on the moment
and the distribution. The \code{moments()} function returns a list with all the
available methods.
\item Estimation: Returns a list, the estimators of the unknown parameters. Note
that in distribution families like the binomial, multinomial, and negative
binomial, the size is not returned, since it is considered known.
\item Variance: Returns a named matrix. The asymptotic covariance matrix of the
estimator.
}
}
\description{
The Uniform distribution is an absolute continuous probability distribution
where all intervals of the same length within the distribution's support are
equally probable. It is defined by two parameters: the lower bound \eqn{a}
and the upper bound \eqn{b}, with \eqn{a < b}.
}
\details{
The probability density function (PDF) of the Uniform distribution is:
\deqn{ f(x; a, b) = \frac{1}{b - a}, \quad a \le x \le b .}
}
\examples{
# -----------------------------------------------------
# Uniform Distribution Example
# -----------------------------------------------------

# Create the distribution
a <- 3 ; b <- 5
D <- Unif(a, b)

# ------------------
# dpqr Functions
# ------------------

d(D, c(0.3, 0.8, 0.5)) # density function
p(D, c(0.3, 0.8, 0.5)) # distribution function
qn(D, c(0.4, 0.8)) # inverse distribution function
x <- r(D, 100) # random generator function

# alternative way to use the function
df <- d(D) ; df(x) # df is a function itself

# ------------------
# Moments
# ------------------

mean(D) # Expectation
var(D) # Variance
sd(D) # Standard Deviation
skew(D) # Skewness
kurt(D) # Excess Kurtosis
entro(D) # Entropy

# List of all available moments
mom <- moments(D)
mom$mean # expectation

# ------------------
# Point Estimation
# ------------------

ll(D, x)
llunif(x, a, b)

eunif(x, type = "mle")
eunif(x, type = "me")

mle(D, x)
me(D, x)
e(D, x, type = "mle")

mle("unif", x) # the distr argument can be a character
}
\seealso{
Functions from the \code{stats} package: \code{\link[=dunif]{dunif()}}, \code{\link[=punif]{punif()}}, \code{\link[=qunif]{qunif()}},
\code{\link[=runif]{runif()}}
}
