% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boxLine.R
\name{boxLine}
\alias{boxLine}
\title{boxLine: Produces  two graphs - boxplots of disaggregated population counts across groups and a line plot showing the distribution of the
aggregated totals of the disaggregated counts}
\usage{
boxLine(dmat, xlab, ylab)
}
\arguments{
\item{dmat}{A data frame containing the group-structured disaggregated population estimates which could be observed or from modelled estimates based on any of the functions -
cheesecake', 'cheesepop', 'slices','spices', 'spray' , 'sprinkle', 'splash', 'spray', 'sprinkle1', 'splash1', or 'spray1'.
considered.}

\item{xlab}{A user-defined label for the x-axis (e.g., 'Age group').}

\item{ylab}{A user-defined label for the y-axis (e.g., 'Population count').}
}
\value{
A graphic image of two combined graphs - a boxplot and a line plot showing the distribution of the disaggregated  population counts across the groups.
}
\description{
This function automatically generates two graphs that are combined together - (a) a boxplot  of the distribution of the various groups'
disaggregated population counts, and (b) a line graph of the aggregated counts across all groups (e.g., total number of individuals for each group).
Here, the input data could come from any of the disaggregation functions within the 'jollofR' package such as 'cheesecake', 'cheesepop', 'slices' & 'spices'.
}
\examples{
\donttest{
if (requireNamespace("INLA", quietly = TRUE)) {
 library(ggplot2)
 data(toydata)
 result <- cheesepop(df = toydata$admin,output_dir = tempdir())
 boxLine(dmat=result$male_age_pop,
         xlab="Age group (years)",
         ylab = "Population Count")
}
}

}
