% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/losses.R
\name{loss_categorical_generalized_cross_entropy}
\alias{loss_categorical_generalized_cross_entropy}
\title{Computes the generalized cross entropy loss.}
\usage{
loss_categorical_generalized_cross_entropy(
  y_true,
  y_pred,
  q = 0.5,
  ...,
  reduction = "sum_over_batch_size",
  name = "categorical_generalized_cross_entropy",
  dtype = NULL
)
}
\arguments{
\item{y_true}{Integer class indices with shape \code{(batch_size)} or \verb{(batch_size, 1)}.}

\item{y_pred}{Predicted class probabilities with shape \verb{(batch_size, num_classes)}.}

\item{q}{Float in \verb{(0, 1)}. Controls the transition between cross entropy and mean
absolute error. Defaults to \code{0.5}.
\itemize{
\item As \code{q} approaches \code{0}: behaves like categorical cross entropy.
\item As \code{q} approaches \code{1}: behaves like mean absolute error.
}}

\item{...}{For forward/backward compatibility.}

\item{reduction}{Type of reduction to apply to the loss. In almost all cases
this should be \code{"sum_over_batch_size"}. Supported options are
\code{"sum"}, \code{"sum_over_batch_size"}, \code{"mean"},
\code{"mean_with_sample_weight"} or \code{NULL}. \code{"sum"} sums the loss,
\code{"sum_over_batch_size"} and \code{"mean"} sum the loss and divide by the
sample size, and \code{"mean_with_sample_weight"} sums the loss and
divides by the sum of the sample weights. \code{"none"} and \code{NULL}
perform no aggregation. Defaults to \code{"sum_over_batch_size"}.}

\item{name}{Optional name for the loss instance.}

\item{dtype}{Dtype used for loss computations. Defaults to \code{config_floatx()} (the global
float type).}
}
\value{
Generalized cross entropy loss value(s).
}
\description{
The generalized cross entropy (GCE) loss offers robustness to noisy labels by
interpolating between categorical cross entropy (\code{q -> 0}) and mean absolute
error (\code{q -> 1}). For a true-class probability \code{p} and noise parameter \code{q},
the loss is \code{loss = (1 - p^q) / q}.
}
\section{References}{
\itemize{
\item Zhang & Sabuncu (2018), "Generalized Cross Entropy Loss for Training Deep
Neural Networks with Noisy Labels"
}
}

\section{Examples}{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{y_true <- c(0L, 1L, 0L, 1L)
y_pred <- rbind(
  c(0.7, 0.3),
  c(0.2, 0.8),
  c(0.6, 0.4),
  c(0.4, 0.6)
)
gce <- loss_categorical_generalized_cross_entropy(q = 0.7)
gce(y_true, y_pred)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## tf.Tensor(0.34529287, shape=(), dtype=float32)

}\if{html}{\out{</div>}}
}

\seealso{
Other losses: \cr
\code{\link{Loss}()} \cr
\code{\link{loss_binary_crossentropy}()} \cr
\code{\link{loss_binary_focal_crossentropy}()} \cr
\code{\link{loss_categorical_crossentropy}()} \cr
\code{\link{loss_categorical_focal_crossentropy}()} \cr
\code{\link{loss_categorical_hinge}()} \cr
\code{\link{loss_circle}()} \cr
\code{\link{loss_cosine_similarity}()} \cr
\code{\link{loss_ctc}()} \cr
\code{\link{loss_dice}()} \cr
\code{\link{loss_hinge}()} \cr
\code{\link{loss_huber}()} \cr
\code{\link{loss_kl_divergence}()} \cr
\code{\link{loss_log_cosh}()} \cr
\code{\link{loss_mean_absolute_error}()} \cr
\code{\link{loss_mean_absolute_percentage_error}()} \cr
\code{\link{loss_mean_squared_error}()} \cr
\code{\link{loss_mean_squared_logarithmic_error}()} \cr
\code{\link{loss_poisson}()} \cr
\code{\link{loss_sparse_categorical_crossentropy}()} \cr
\code{\link{loss_squared_hinge}()} \cr
\code{\link{loss_tversky}()} \cr
\code{\link{metric_binary_crossentropy}()} \cr
\code{\link{metric_binary_focal_crossentropy}()} \cr
\code{\link{metric_categorical_crossentropy}()} \cr
\code{\link{metric_categorical_focal_crossentropy}()} \cr
\code{\link{metric_categorical_hinge}()} \cr
\code{\link{metric_hinge}()} \cr
\code{\link{metric_huber}()} \cr
\code{\link{metric_kl_divergence}()} \cr
\code{\link{metric_log_cosh}()} \cr
\code{\link{metric_mean_absolute_error}()} \cr
\code{\link{metric_mean_absolute_percentage_error}()} \cr
\code{\link{metric_mean_squared_error}()} \cr
\code{\link{metric_mean_squared_logarithmic_error}()} \cr
\code{\link{metric_poisson}()} \cr
\code{\link{metric_sparse_categorical_crossentropy}()} \cr
\code{\link{metric_squared_hinge}()} \cr
}
\concept{losses}
