% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/row-id.R
\name{extend_id}
\alias{extend_id}
\title{Extend IDs to new rows}
\usage{
extend_id(.data, .id = ".id")
}
\arguments{
\item{.data}{A data frame with an ID column (possibly with NAs).}

\item{.id}{Column name for IDs (default: ".id").}
}
\value{
Data frame with IDs filled in for NA rows.
}
\description{
Adds IDs to rows where the ID column is NA, preserving existing IDs.
Useful after binding new data to an existing dataset with IDs.
}
\examples{
# Original data with IDs
old <- add_id(data.frame(x = 1:3))

# New data without IDs
new <- data.frame(.id = NA_character_, x = 4:5)

# Combine and extend
combined <- dplyr::bind_rows(old, new)
extend_id(combined)

}
