% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assume.R
\name{lock_no_na}
\alias{lock_no_na}
\title{Assert that columns have no missing values}
\usage{
lock_no_na(.data, ..., .strict = FALSE)
}
\arguments{
\item{.data}{A data frame.}

\item{...}{Column names (unquoted) to check. If empty, checks all columns.}

\item{.strict}{If \code{TRUE}, error on failure. If \code{FALSE} (default), warn.}
}
\value{
Invisibly returns \code{.data} (for piping).
}
\description{
Checks that specified columns contain no NA values.
}
\examples{
df <- data.frame(id = 1:3, x = c("a", NA, "c"))
lock_no_na(df, id)
lock_no_na(df, x)  # warns

}
