% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/egfr_schwartz.R
\name{egfr.schwartz.cr_cys}
\alias{egfr.schwartz.cr_cys}
\title{Calculate eGFR by Schwartz multivariate equation with cystatin C, ht/Scr, and BUN(for children only)}
\usage{
egfr.schwartz.cr_cys(
  creatinine,
  creatinine_units = "mg/dL",
  cystatin,
  cystatin_units = "mg/L",
  bun,
  bun_units = "mg/dL",
  sex,
  height_cm = 0,
  height_ft = 0,
  height_inch = 0,
  label_sex_male = c("Male", 1),
  label_sex_female = c("Female", 0)
)
}
\arguments{
\item{creatinine}{Numeric vector. Serum creatinine, could be expressed in "micromol/L", "mmol/L" or "mg/dL". Units of measurement should be defined in variable creatinine_units (if not defined explicitly by user, the default value is "micromol/L").}

\item{creatinine_units}{Character string. Units in which serum creatinine is expressed. Could be one of the following: "micromol/L", "mmol/L" or "mg/dL".}

\item{cystatin}{Numeric vector. Serum cystatin, could be expressed in "mg/L" or "nanomol/L". Units of measurement should be defined in variable cystatin_units (if not defined explicitly by user, the default value is "mg/L").}

\item{cystatin_units}{Character string. Units in which serum cystatin is expressed. Could be one of the following: "mg/L" or "nanomol/L".}

\item{bun}{Numeric vector. Blood urea nitrogen, could be expressed in "mg/dL" or "mmol/L". Units of measurement should be defined in variable bun_units (if not defined explicitly by user, the default value is "mg/dL").}

\item{bun_units}{Character string. Units in which blood urea nitrogen is expressed. Could be one of the following: "mg/dL" or "mmol/L".}

\item{sex}{Vector. The value of variable refers to the parameters label_sex_male and label_sex_female.}

\item{height_cm}{Numeric vector. Could be defined either as height_cm if is measured in cm, or as height_ft and height_inch if is measured in feet and inches.
If the parameter height_cm is greater than 0, the function uses cm, otherwise - feet and inches.}

\item{height_ft}{see height_cm}

\item{height_inch}{see height_cm}

\item{label_sex_male}{List. Label(s) for definition(s) of male sex.}

\item{label_sex_female}{List. Label(s) for definition(s) of female sex.}
}
\value{
numeric eGFR expressed in ml/min/1.73m\ifelse{html}{\out{<sup>2</sup>}}{\eqn{^2}}.
}
\description{
Calculate eGFR by Schwartz multivariate equation with cystatin C, ht/Scr, and BUN(for children only)
}
\details{
Calculate estimated glomerular filtration rate (eGFR) by Schwartz  multivariate equation with cystatin C, ht/Scr, and BUN.

Reference to the equation: Schwartz GJ, Schneider MF, Maier PS et al. Improved equations estimating GFR in children with chronic kidney disease using an immunonephelometric determination of cystatin C. Kidney Int 2012; 82: 445–453.

Citation: Bikbov B. kidney.epi: Kidney-Related Functions for Clinical and Epidemiological Research. Scientific-Tools.Org, https://Scientific-Tools.Org. DOI: 10.32614/CRAN.package.kidney.epi
}
\author{
Programming: Boris Bikbov https://www.linkedin.com/in/boris-bikbov.
}
