% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sigma.est.R
\name{Sigma.est}
\alias{Sigma.est}
\title{Covariance matrix of components of Lancaster correlation coefficient}
\usage{
Sigma.est(xx)
}
\arguments{
\item{xx}{a matrix or data frame with two columns.}
}
\value{
the estimated covariance matrix.
}
\description{
Estimate of covariance matrix of the two components of Lancaster correlation. Lancaster correlation is a bivariate measures of dependence.
}
\details{
For more details see the Appendix in Holzmann, Klar (2024).
}
\examples{
Sigma <- matrix(c(1,0.1,0.1,1), ncol=2)
R <- chol(Sigma)
n <- 1000
x <- matrix(rnorm(n*2), n)
nu <- 8
y <- x / sqrt(rchisq(n, nu)/nu) #multivariate t
Sigma.est(y)

}
\references{
Holzmann, Klar (2024). "Lancester correlation - a new dependence measure linked to maximum correlation". \doi{https://doi.org/10.1111/sjos.12733}
}
\seealso{
\code{\link{lcor.ci}}
}
\author{
Hajo Holzmann, Bernhard Klar
}
