% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/additional_distributions.R
\name{Gumbel_distribution}
\alias{Gumbel_distribution}
\alias{dgumbel}
\alias{pgumbel}
\alias{qgumbel}
\title{The Gumbel Distribution}
\usage{
dgumbel(x, location, scale)

pgumbel(q, location, scale, lower.tail = TRUE)

qgumbel(p, location = 0, scale = 1, lower.tail = TRUE)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{location}{numerical. It represents location parameter. See Details.}

\item{scale}{numerical. It represents scale parameter.  See Details.}

\item{lower.tail}{logical; if \code{TRUE} (default), probabilities are \eqn{P[X \leq x]} otherwise, \eqn{P[X > x]}.}

\item{p}{vector of probabilities.}
}
\description{
Density, distribution function, quantile function and random generation
for the normal distribution with parameters: location and scale
}
\details{
The CDF of Gumbel distribution is:
\deqn{
   F(x;\mu ,\beta )=e^{-e^{-(x-\mu )/\beta }}, \quad \mu \in \mathbf{R}, \beta > 0,
}
where \eqn{\mu} is location parameter (\code{location}) and \eqn{\beta} is scale parameter (\code{scale}).
The PDF of Gumbel distribution is:
\deqn{
   \frac{1}{\beta }e^{-(z+e^{-z})},
}
where \eqn{z={\frac {x-\mu }{\beta }}}.
The quantile is:
\deqn{
  \mu -\beta \ln(-\ln(p)), \quad 0 < p < 1.
}
}
\examples{
# PDF
dgumbel(1, 0, 1)
# CDF
pgumbel(1, 0, 1)
# Quantile
qgumbel(0.2, 0, 1)
}
