% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core-fisher_mle.R
\name{fisher_mle}
\alias{fisher_mle}
\title{Maximum Likelihood Estimate (Fisherian)}
\usage{
fisher_mle(
  par,
  vcov = NULL,
  loglik_val,
  hessian = NULL,
  score_val = NULL,
  nobs = NULL,
  converged = TRUE,
  optim_result = NULL
)
}
\arguments{
\item{par}{Numeric vector of parameter estimates (may be named)}

\item{vcov}{Variance-covariance matrix of the estimates}

\item{loglik_val}{Log-likelihood value at the MLE}

\item{hessian}{Hessian matrix of the log-likelihood at the MLE}

\item{score_val}{Optional score vector at the MLE (should be near zero)}

\item{nobs}{Number of observations used in estimation}

\item{converged}{Logical indicating if optimization converged}

\item{optim_result}{Raw result from optim() for diagnostics}
}
\value{
An object of class \code{c("fisher_mle", "mle")}
}
\description{
Creates a \code{fisher_mle} object representing a maximum likelihood estimate
with methods for standard inference. This class emphasizes the Fisherian
approach to likelihood-based inference.
}
