% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/limer_upload_tsv_to_limesurvey.R
\name{limer_upload_tsv_to_limesurvey}
\alias{limer_upload_tsv_to_limesurvey}
\title{Upload a tab separated limesurvey text file}
\usage{
limer_upload_tsv_to_limesurvey(
  ls_txt_path,
  open_url = "preview",
  hostname = getOption("lime_api")
)
}
\arguments{
\item{ls_txt_path}{Path of the limesurvey text file}

\item{open_url}{Character vector containing one or more of the strings in
\code{c("preview", "survey", "none")}. If it contains "none", nothing is done.
\code{"preview"} (the default) previews the survey on limesurvey. \code{"survey"}
opens the survey summary.}

\item{hostname}{The host to use (if not using the one specified in
the options). If no hostname is specified in the \code{'lime_api'} option and
no host name is passed as \code{hostname}, the subdomain stored in
\code{limonaid::opts$get("ls_subdomain")} will be combined with the
domain stored in \code{limonaid::opts$get("ls_domain")} to create the
host name. You can change these using the \code{limonaid::opts$set()} function.}
}
\value{
The value of the id of your survey in the specified
LimeSurvey installation,
}
\description{
To use this function, you need to setup R for the LimeSuevey API, as
described in \code{vignette("limesurvey_api_setup")}.
}
\examples{

\dontrun{
### Log into the LimeSurvey API:
limonaid::get_session_key();

### Upload a tab separated values file:
limer_upload_tsv_to_limesurvey(
  "PATH/TO/YOUR/LIMESURVEY/TXT FILE",
  c("preview", "survey")
);
}
}
