% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{Fastfood}
\alias{Fastfood}
\title{Card and Krueger (1994) fastfood data set}
\format{
A data frame with 820 rows and 35 variables:
\describe{
  \item{id}{ID of fastfood restaurant [+]}
  \item{sheet}{sheet number (unique store id)}
  \item{after}{1 if second interview [+]}
  \item{chain}{chain 1=bk; 2=kfc; 3=roys; 4=wendys}
  \item{co_owned}{1 if company owned}
  \item{nj}{1 if NJ; 0 if Pa}
  \item{southj}{1 if in southern NJ}
  \item{centralj}{1 if in central NJ}
  \item{northj}{1 if in northern NJ}
  \item{pa1}{1 if in PA, northeast suburbs of Philadelphia}
  \item{pa2}{1 if in PA, Easton etc}
  \item{shore}{1 if on NJ shore}
  \item{type2}{type 2nd interview 1=phone; 2=personal}
  \item{status2}{status of second interview; see details}
  \item{date2}{date of second interview MMDDYY format}
  \item{ncalls}{number of call-backs*}
  \item{empft}{# full-time employees}
  \item{emppt}{# part-time employees}
  \item{nmgrs}{# managers/assistant managers}
  \item{fte}{full time equivalent, FTE = empft + nmgrs + 0.5*emppt [+]}
  \item{dfte}{FTE for after - FTE for before [+]}
  \item{wage_st}{starting wage ($/hr)}
  \item{inctime}{months to usual first raise}
  \item{firstinc}{usual amount of first raise ($/hr)}
  \item{bonus}{1 if cash bounty for new workers}
  \item{pctaff}{\% employees affected by new minimum}
  \item{meals}{free/reduced price code (see details)}
  \item{open}{hour of opening}
  \item{hrsopen}{number hrs open per day}
  \item{psoda}{price of medium soda, including tax}
  \item{pfry}{price of small fries, including tax}
  \item{pentree}{price of entree, including tax}
  \item{nregs}{number of cash registers in store}
  \item{nregs11}{number of registers open at 11:00 am}
  \item{balanced}{1 if empft, nmgrs and emppt observed both periods [+]}
}
}
\source{
\url{https://davidcard.berkeley.edu/data_sets.html}
}
\usage{
data(Fastfood)
}
\description{
Card and Krueger (1994) fastfood data set
}
\details{
See \code{attr(Fastfood, "desc")}. [+] are added by Chirok Han.
}
\references{
Card, D., and A. Krueger (1994). Minimum Wages and Employment: A Case Study of the Fast Food Industry in New Jersey and Pennsylvania, American Economic Review 84, 772-793.
}
\keyword{datasets}
