% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l_layer_sp.R
\name{spunlist}
\alias{spunlist}
\title{Create a flat list of polygon specifications
from the list of \code{sp} components returned by \code{spAsList}}
\usage{
spunlist(x)
}
\arguments{
\item{x}{An \code{list} spatial data object.}
}
\value{
An appropriately flattened list of the relevant components of the spatial data object.
}
\description{
\code{spunlist} is a simple helper function taking the output
from \code{spAsList}. It is a helper function that should
rarely be called directly by the user.
It is not the same as the base \code{unlist}.
}
\examples{

a <- list(list(x=1:2, y=1:2),
          list(list(x=1:3, y=1:3),
               list(x=1:4, y=1:4)))
spunlist(a)

# Compare to
unlist(a, recursive=TRUE)
# or to
unlist(a, recursive=FALSE)

}
\seealso{
\code{\link{spAsList}}
}
\keyword{internal}
