% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{pbvnorm}
\alias{pbvnorm}
\title{Distribution Function of the Standard Bivariate Normal}
\usage{
pbvnorm(lower = c(-Inf, Inf), upper = c(Inf, Inf), corr = 0)
}
\arguments{
\item{lower}{A numeric vector of length 2 specifying the lower limits
of integration.}

\item{upper}{A numeric vector of length 2 specifying the upper limits
of integration.}

\item{corr}{A numeric value specifying the correlation coefficient of
the standard bivariate normal distribution.}
}
\value{
A numeric value representing the probability that a standard
bivariate normal vector falls within the specified rectangular region.
}
\description{
Computes the cumulative distribution function (CDF) of
the standard bivariate normal distribution with specified lower and
upper integration limits and correlation coefficient.
}
\details{
This function evaluates the probability
\eqn{P(\code{lower[1]} < X < \code{upper[1]},
\code{lower[2]} < Y < \code{upper[2]})} where
\eqn{(X, Y)} follows a standard bivariate normal
distribution with correlation \code{corr}.
}
\examples{
pbvnorm(c(-1, -1), c(1, 1), 0.5)

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
