% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_treecover_area.R
\name{treecover_area}
\alias{treecover_area}
\alias{calc_treecover_area}
\title{Calculate treecover statistics}
\usage{
calc_treecover_area(years = 2000:2024, min_size = 10, min_cover = 35)
}
\arguments{
\item{years}{A numeric vector with the years for which to calculate treecover
area.}

\item{min_size}{The minimum size of a forest patch to be considered as forest in ha.}

\item{min_cover}{The minimum cover percentage per pixel to be considered as forest.}
}
\value{
A function that returns an indicator tibble with variable treecover
and corresponding area (in ha) as value.

If the \link{gfw_treecover} resource for an asset contains only zeros (no trees at all,
e.g. big water body like an ocean or a sea),
the \code{NULL} value is returned instead of the indicator tibble.
If it doesn't contain any pixels with value >=  \code{min_cover}, indicator tibble
reports area of zero hectares.
}
\description{
This functions allows to efficiently calculate treecover statistics for
polygons. For each year in the analysis timeframe, the forest losses in
preceding and the current years are subtracted from the treecover in the
year 2000 and actual treecover figures within the polygon are returned.
}
\details{
The required resources for this indicator are:
\itemize{
\item \link{gfw_treecover}
\item \link{gfw_lossyear}
}
}
\examples{
\dontshow{
mapme.biodiversity:::.copy_resource_dir(file.path(tempdir(), "mapme-data"))
}
\dontrun{
library(sf)
library(mapme.biodiversity)

outdir <- file.path(tempdir(), "mapme-data")
dir.create(outdir, showWarnings = FALSE)

mapme_options(
  outdir = outdir,
  verbose = FALSE
)

aoi <- system.file("extdata", "sierra_de_neiba_478140_2.gpkg",
  package = "mapme.biodiversity"
) \%>\%
  read_sf() \%>\%
  get_resources(
    get_gfw_treecover(version = "GFC-2024-v1.12"),
    get_gfw_lossyear(version = "GFC-2024-v1.12")
  ) \%>\%
  calc_indicators(calc_treecover_area(years = 2016:2017, min_size = 1, min_cover = 30)) \%>\%
  portfolio_long()

aoi
}
}
\keyword{indicator}
