
ices.rect.lutx <- function() {
  ## A0,A1,A2,A3 then B0,B1 etc, skip I, and end with M9
  x <- c(paste0("A",0:3),paste0(rep(c("B","C","D","E","F","G","H","J","K","L"),each=10),0:9),paste0("M",0:8))
  midlon <- -43.5:68.5
  return(data.frame(x,midlon))
}

ices.rect.luty <- function() {
  y <- sprintf("%02d", 1:98)
  midlat <- seq(36.25,84.75,by=0.5)
  return(data.frame(y,midlat))
}


ices.rect <- function(rectangle) {
  lutx <- ices.rect.lutx()
  x <- substring(rectangle,3,4)
  i <- match(x,lutx$x)
  lon <- lutx$midlon[i]
  
  luty <- ices.rect.luty()
  y <- substring(rectangle,1,2)
  i <- match(y,luty$y)
  lat <- luty$midlat[i]
  
  lon[is.na(lat)] <- NA
  lat[is.na(lon)] <- NA
  
  return(data.frame(lon,lat))
}

ices.rect2 <- function (lon, lat) {
  lutx <- ices.rect.lutx()
  midlon <- floor(lon)+0.5
  i <- match(sprintf("%.1f", midlon),sprintf("%.1f",lutx$midlon))
  x <- lutx$x[i]
  
  luty <- ices.rect.luty()
  midlat <- floor(lat * 2)/2+0.25
  i <- match(sprintf("%.2f", midlat),sprintf("%.2f",luty$midlat))
  y <- luty$y[i]
  
  x[is.na(y)] <- NA
  y[is.na(x)] <- NA
  out <- paste0(y,x)
  out[out=="NANA"] <- NA
  
  return(out)
}
