.gmapsf$themes <- list(
  base = list(
    mar          = c(0.5, 0.5, 2.25, 0.5),
    title_tab    = FALSE,
    title_pos    = "center",
    title_inner  = FALSE,
    title_line   = 1.75,
    title_cex    = 1.25,
    title_font   = 2,
    title_banner = FALSE,
    frame        = "none",
    frame_lwd    = 1,
    frame_lty    = 1,
    foreground   = "grey75",
    background   = "#fbfbfb",
    highlight    = "#500f27",
    pal_quali    = "Dark 3",
    pal_seq      = "BrwnYl"
  ),
  grey = list(
    mar          = c(0.5, 0.5, 2.25, 0.5),
    title_tab    = FALSE,
    title_pos    = "center",
    title_inner  = FALSE,
    title_line   = 1.75,
    title_cex    = 1.25,
    title_font   = 2,
    title_banner = TRUE,
    frame        = "none",
    frame_lwd    = 1,
    frame_lty    = 1,
    background   = "grey95",
    foreground   = "grey70",
    highlight    = "grey10",
    pal_seq      = "Grays",
    pal_quali    = "Pastel 1"
  ),
  sol_light = list(
    mar          = c(0.5, 0.5, 2.25, 0.5),
    title_tab    = FALSE,
    title_pos    = "left",
    title_inner  = FALSE,
    title_line   = 1.75,
    title_cex    = 1.25,
    title_font   = 2,
    title_banner = FALSE,
    frame        = "none",
    frame_lwd    = 1,
    frame_lty    = 1,
    background   = "#fdf6e3",
    foreground   = "#93a1a1",
    highlight    = "grey10",
    pal_seq      = "BurgYl",
    pal_quali    = "Pastel 1"
  ),
  sol_dark = list(
    mar = c(0.5, 0.5, 2.25, 0.5),
    title_tab = FALSE,
    title_pos = "left",
    title_inner = FALSE,
    title_line = 1.75,
    title_cex = 1.25,
    title_font = 2,
    title_banner = FALSE,
    frame = "none",
    frame_lwd = 1,
    frame_lty = 1,
    background = "#073642",
    foreground = "#93a1a1",
    highlight = "grey95",
    pal_seq = colorRampPalette(c(
      "#002b36", "#657b83",
      "#839496", "#eee8d5"
    )),
    pal_quali = "Pastel 1"
  ),
  mint = list(
    mar          = c(0.25, 0.25, 2, 0.25) + .5,
    title_tab    = FALSE,
    title_pos    = "center",
    title_inner  = FALSE,
    title_line   = 1.75,
    title_cex    = 1.25,
    title_font   = 2,
    title_banner = FALSE,
    frame        = "map",
    frame_lwd    = 1,
    frame_lty    = "5252",
    background   = "grey98",
    foreground   = "#C0EBA6",
    highlight    = "#7d698c",
    pal_seq      = "Emrld",
    pal_quali    = "Pastel 1"
  ),
  dracula = list(
    mar          = c(0.5, 0.5, 2.25, 0.5) - .5,
    title_tab    = FALSE,
    title_pos    = "center",
    title_inner  = FALSE,
    title_line   = 1.75,
    title_cex    = 1.25,
    title_font   = 2,
    title_banner = FALSE,
    frame        = "none",
    frame_lwd    = 1,
    frame_lty    = "5252",
    background   = "#22212c",
    foreground   = "#7359f8",
    highlight    = "#fefe7f",
    pal_seq      = "Purples 3",
    pal_quali    = "Warm"
  ),
  rzine = list(
    mar          = c(0, 0, 1.21, 0),
    title_tab    = FALSE,
    title_pos    = "center",
    title_inner  = FALSE,
    title_line   = 1.2,
    title_cex    = 1,
    title_font   = 2,
    title_banner = FALSE,
    frame        = "figure",
    frame_lwd    = 1,
    frame_lty    = "5252",
    background   = "#b2c3e6",
    foreground   = "#4d77ba",
    highlight    = "#FFFEF3",
    pal_seq      = "Blues 3",
    pal_quali    = "Warm"
  ),
  pistachio = list(
    mar          = c(0, 0, 1.21, 0),
    title_tab    = FALSE,
    title_pos    = "center",
    title_inner  = FALSE,
    title_line   = 1.2,
    title_cex    = 1,
    title_font   = 2,
    title_banner = FALSE,
    frame        = "figure",
    frame_lwd    = 1,
    frame_lty    = "5252",
    foreground   = "#D2E2C3",
    background   = "#EFF3EA",
    highlight    = "#73607A",
    pal_seq      = "Purples 3",
    pal_quali    = "Warm"
  ),
  # legacy themes
  default = list(
    mar = c(.5, .5, 1.7, .5),
    title_tab = TRUE,
    title_pos = "left",
    title_inner = FALSE,
    title_line = 1.2,
    title_cex = 1,
    title_font = 1,
    title_banner = TRUE,
    foreground = "#333333",
    background = "#f7f7f7",
    highlight = "#333333",
    pal_quali = "Set 2",
    pal_seq = "Mint",
    legacy = TRUE,
    frame = "none"
  ),
  brutal = list(
    background = "#FFFFFF",
    foreground = "#3b4252",
    mar = c(5.1, 4.1, 4.1, 2.1),
    title_tab = TRUE,
    title_pos = "left",
    title_inner = FALSE,
    title_line = 2,
    title_cex = 1.5,
    title_font = 2,
    highlight = "#3b4252",
    pal_quali = "Set 2",
    pal_seq = "Mint",
    legacy = TRUE,
    frame = "none"
  ),
  ink = list(
    background = "#FFDEAD",
    foreground = "#0000FF",
    mar = c(0, 0, 1.2, 0),
    title_tab = FALSE,
    title_pos = "left",
    title_inner = FALSE,
    title_line = 1.2,
    title_cex = .9,
    title_font = 2,
    highlight = "#0000FF",
    pal_quali = "Set 2",
    pal_seq = "Mint",
    legacy = TRUE,
    frame = "none"
  ),
  dark = list(
    background = "#2E3947",
    foreground = "#7E848C",
    mar = c(0.5, 0.5, 2, 0.5),
    title_tab = FALSE,
    title_pos = "left",
    title_inner = FALSE,
    title_line = 1.5,
    title_cex = 1,
    title_font = 1,
    highlight = "#7E848C",
    pal_quali = "Set 2",
    pal_seq = "Mint",
    legacy = TRUE,
    frame = "none"
  ),
  agolalight = list(
    background = "#EDF4F5",
    foreground = "#82888A",
    mar = c(0, 0, 2, 0),
    title_tab = FALSE,
    title_pos = "left",
    title_inner = FALSE,
    title_line = 2,
    title_cex = 1.5,
    title_font = 3,
    highlight = "#82888A",
    pal_quali = "Set 2",
    pal_seq = "Mint",
    legacy = TRUE,
    frame = "none"
  ),
  candy = list(
    background = "#FDFCFE",
    foreground = "#6B1767",
    mar = c(0, 0, 2, 0),
    title_tab = FALSE,
    title_pos = "center",
    title_inner = FALSE,
    title_line = 2,
    title_cex = 1.5,
    title_font = 2,
    highlight = "#6B1767",
    pal_quali = "Set 2",
    pal_seq = "Mint",
    legacy = TRUE,
    frame = "none"
  ),
  darkula = list(
    background = "#232525",
    foreground = "#A9B7C6",
    mar = c(0.5, 0.5, 0.5, 0.5),
    title_tab = TRUE,
    title_pos = "right",
    title_inner = TRUE,
    title_line = 1.5,
    title_cex = 1,
    title_font = 4,
    highlight = "#A9B7C6",
    pal_quali = "Set 2",
    pal_seq = "Mint",
    legacy = TRUE,
    frame = "none"
  ),
  iceberg = list(
    background = "#0B0E0E",
    foreground = "#BDD6DB",
    mar = c(0.5, 0.5, 0.5, 0.5),
    title_tab = TRUE,
    title_pos = "right",
    title_inner = TRUE,
    title_line = 1.5,
    title_cex = 1,
    title_font = 4,
    highlight = "#BDD6DB",
    pal_quali = "Set 2",
    pal_seq = "Mint",
    legacy = TRUE,
    frame = "none"
  ),
  green = list(
    background = "#1B1D16",
    foreground = "#D7FF68",
    mar = c(0.5, 0.5, 2, 0.5),
    title_tab = FALSE,
    title_pos = "center",
    title_inner = FALSE,
    title_line = 1.5,
    title_cex = 1,
    title_font = 2,
    highlight = "#D7FF68",
    pal_quali = "Set 2",
    pal_seq = "Mint",
    legacy = TRUE,
    frame = "none"
  ),
  nevermind = list(
    background = "#4DB8DA",
    foreground = "#121725",
    mar = c(2, 2, 3.5, 2),
    title_tab = FALSE,
    title_pos = "center",
    title_inner = FALSE,
    title_line = 1.5,
    title_cex = 1.4,
    title_font = 1,
    highlight = "#121725",
    pal_quali = "Set 2",
    pal_seq = "Mint",
    legacy = TRUE,
    frame = "none"
  ),
  jsk = list(
    background = "#ffdc11",
    foreground = "#0c973c",
    mar = c(0, 0, 1.5, 0),
    title_tab = FALSE,
    title_pos = "left",
    title_inner = FALSE,
    title_line = 1.5,
    title_cex = 1,
    title_font = 2,
    highlight = "#0c973c",
    pal_quali = "Set 2",
    pal_seq = "Mint",
    legacy = TRUE,
    frame = "none"
  ),
  barcelona = list(
    background = "#160808",
    foreground = "#d73e23",
    mar = c(0, 0, 1.2, 0),
    title_tab = TRUE,
    title_pos = "left",
    title_inner = FALSE,
    title_line = 1.2,
    title_cex = 1,
    title_font = 2,
    highlight = "#d73e23",
    pal_quali = "Set 2",
    pal_seq = "Mint",
    legacy = TRUE,
    frame = "none"
  )
)


.onLoad <- function(libname, pkgname) {
  theme <- .gmapsf$themes$base
  options(
    mapsf.mar          = theme$mar,
    mapsf.title_tab    = theme$title_tab,
    mapsf.title_pos    = theme$title_pos,
    mapsf.title_inner  = theme$title_inner,
    mapsf.title_line   = theme$title_line,
    mapsf.title_cex    = theme$title_cex,
    mapsf.title_font   = theme$title_font,
    mapsf.title_banner = theme$title_banner,
    mapsf.foreground   = theme$foreground,
    mapsf.background   = theme$background,
    mapsf.highlight    = theme$highlight,
    mapsf.pal_quali    = theme$pal_quali,
    mapsf.pal_seq      = theme$pal_seq,
    mapsf.legacy       = theme$legacy,
    mapsf.frame        = theme$frame,
    mapsf.frame_lwd    = theme$frame_lwd,
    mapsf.frame_lty    = theme$frame_lty
  )
}
