% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mf_prop.R
\name{mf_prop}
\alias{mf_prop}
\title{Plot proportional symbols}
\usage{
mf_prop(
  x,
  var,
  inches = 0.3,
  val_max,
  lwd_max = 20,
  symbol = "circle",
  col,
  alpha = NULL,
  border,
  lwd = 0.7,
  leg_pos = mf_get_leg_pos(x),
  leg_title = var,
  leg_title_cex = 0.8,
  leg_val_cex = 0.6,
  leg_val_rnd = 0,
  leg_frame = FALSE,
  leg_frame_border,
  leg_horiz = FALSE,
  leg_adj = c(0, 0),
  leg_fg,
  leg_bg,
  leg_size = 1,
  add = TRUE
)
}
\arguments{
\item{x}{object of class \code{sf}}

\item{var}{name(s) of the variable(s) to plot}

\item{inches}{size of the biggest symbol (radius for circles, half width for squares) in inches.}

\item{val_max}{maximum value used for proportional symbols}

\item{lwd_max}{line width of the largest line}

\item{symbol}{type of symbols, 'circle' or 'square'}

\item{col}{color}

\item{alpha}{opacity, in the range [0,1]}

\item{border}{border color}

\item{lwd}{border width}

\item{leg_pos}{position of the legend, one of 'topleft', 'top','topright', 'right', 'bottomright', 'bottom', 'bottomleft', 'left' or a vector of two coordinates in map units (c(x, y)). If leg_pos = NA then the legend is not plotted. If leg_pos = 'interactive' click onthe map to choose the legend position.}

\item{leg_title}{legend title}

\item{leg_title_cex}{size of the legend title}

\item{leg_val_cex}{size of the values in the legend}

\item{leg_val_rnd}{number of decimal places of the values in the legend}

\item{leg_frame}{whether to add a frame to the legend (TRUE) or not (FALSE)}

\item{leg_frame_border}{border color of the legend frame}

\item{leg_horiz}{display the legend horizontally (for proportional symbols and choropleth types)}

\item{leg_adj}{adjust the postion of the legend in x and y directions}

\item{leg_fg}{color of the legend foreground}

\item{leg_bg}{color of the legend backgournd}

\item{leg_size}{size of the legend; 2 means two times bigger}

\item{add}{whether to add the layer to an existing plot (TRUE) or not (FALSE)}
}
\value{
x is (invisibly) returned.
}
\description{
Plot proportional symbols.
}
\examples{
mtq <- mf_get_mtq()
mf_map(mtq)
mf_map(mtq, "POP", "prop")

mf_map(mtq)
mf_map(
  x = mtq, var = "POP", type = "prop",
  inches = .4, symbol = "circle", val_max = 90000,
  col = "tomato1", border = "blue", lwd = 1,
  leg_pos = "right", leg_title = "Population",
  leg_title_cex = 1, leg_val_cex = .8, leg_val_rnd = 0,
  leg_frame = TRUE, add = TRUE
)
}
\keyword{internal}
