% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/F23.R
\name{F23}
\alias{F23}
\title{Shekel 10 Function (F23)}
\usage{
F23(x)
}
\arguments{
\item{x}{Numeric vector of length 4 (4-dimensional input).}
}
\value{
Numeric scalar representing the function value.
}
\description{
A multimodal test function from the Shekel family with 10 local minima.
Fixed dimension of 4.
}
\details{
\strong{Formula:}
\deqn{f(x) = -\sum_{i=1}^{10} \frac{1}{(x - a_i)^T(x - a_i) + c_i}}

where \eqn{a_i} are 4-dimensional vectors and \eqn{c_i} are scalars.

\strong{Global minimum:} \eqn{f(4, 4, 4, 4) \approx -10.5364}

\strong{Characteristics:}
\itemize{
  \item Type: Multimodal
  \item Separable: No
  \item Differentiable: Yes
  \item Fixed dimension: 4
  \item Number of local minima: 10
  \item Default bounds: \eqn{[0, 10]^4}
}

The Shekel 10 function is the most challenging of the Shekel family
due to having the most local minima.
}
\examples{
F23(c(4, 4, 4, 4))  # Returns approximately -10.54 (near global minimum)
F23(c(0, 0, 0, 0))  # Returns a value close to 0

}
\seealso{
\code{\link{test-functions}} for an overview of all test functions,
\code{\link{get_function_details}} to retrieve function parameters,
\code{\link{F21}} for Shekel 5, \code{\link{F22}} for Shekel 7.
}
