% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ext_solutions_df.R
\name{ext_solutions_df}
\alias{ext_solutions_df}
\title{Constructor for \code{ext_solutions_df} class object}
\usage{
ext_solutions_df(ext_sol_dfl, sol_df, fts, target_dl)
}
\arguments{
\item{ext_sol_dfl}{An extended solutions data frame-like object.}

\item{sol_df}{Result of \code{batch_snf} storing cluster solutions and
the settings that were used to generate them.}

\item{fts}{A vector of all features that have association p-values stored
in the resulting extended solutions data frame.}

\item{target_dl}{A data list with features to calculate p-values for.
Features in the target list will be included during p-value summary
measure calculations.}
}
\value{
An \code{ext_solutions_df} class object.
}
\description{
The extended solutions data frame is a column-extended variation of the
solutions data frame. It contains association p-values relating cluster
membership to feature distribution for all solutions in a solutions data
frame and all features in a provided data list (or data lists). If a
target data list was used during the call to \code{extend_solutions}, the
extended solutions data frame will also have columns "min_pval",
"mean_pval", and "max_pval" summarizing the p-values of just those features
that were a part of the target list.
}
\keyword{internal}
