% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{dropallfactors}
\alias{dropallfactors}
\title{Remove all factors in a data frame}
\usage{
dropallfactors(x, unfac2num = FALSE, char2num = FALSE)
}
\arguments{
\item{x}{data.frame object}

\item{unfac2num}{default FALSE; whether try to convert all character columns to numeric directly; 
If TRUE, it will attempt to convert each column, including those of character and factor types. 
First, it tries to convert them to the character type, and then checks if they can be converted to numeric. 
If the conversion to numeric is possible, it outputs the numeric type; otherwise, it outputs the character type.
If FALSE, only columns with the factor attribute will be attempted for conversion. 
Factors will first be converted to character type, and then an attempt will be made to convert them to numeric. 
If successful, the numeric type will be output; otherwise, the character type will be output. This process can effectively remove the factor attribute.
Note that this can only transform the columns that may be transformed to numeric without using factor.}

\item{char2num}{default FALSE; whether force all the character to be numeric class by using factor as an intermediate.
Therefore, this parameter can enforce the conversion of all character and factor types to numeric.
This operation is very useful in some cases that numerical data is required as input.}
}
\value{
data frame without factor
}
\description{
Remove all factors in a data frame
}
\examples{
data("taxonomy_table_16S")
taxonomy_table_16S[, 1] <- as.factor(taxonomy_table_16S[, 1])
str(dropallfactors(taxonomy_table_16S))
}
