% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/experimental.R
\name{mmm}
\alias{mmm}
\title{Convert almost any file into mind map.}
\usage{
mmm(
  input_file = NA,
  output_type = c("widget", "mindmap", "markdown", "mermaid"),
  input_type = c("auto", "markdown", "mindmap", "R", "dir"),
  root = NA,
  md_list = FALSE,
  md_eq = FALSE,
  md_braces = FALSE,
  md_bookdown = FALSE,
  md_maxlevel = "",
  r_seclabel = " --------",
  r_chunkheading = FALSE,
  dir_files = TRUE,
  dir_all = TRUE,
  dir_excluded = NA,
  dir_to = NA,
  dir_quiet = FALSE,
  mmd_shape = c("cloud", "rounded_square", "square", "bang", "circle", "hexagon"),
  widget_name = NA,
  widget_width = NULL,
  widget_height = NULL,
  widget_elementId = NULL,
  widget_options = markmapOption(preset = "colorful")
)
}
\arguments{
\item{input_file}{Character. The path to the file for input.}

\item{output_type}{Character. The type of the output. It can be \code{'widget', 'mindmap', 'markdown', 'R', 'dir', 'mmd'}. The default value is \code{'widget'}.}

\item{input_type}{Character. The type of the input text. It can be \code{'auto', 'markdown', 'mindmap', 'R', 'dir'}. The default value is \code{'auto'}, which means the type will be automatically assigned according to the features of the input text.}

\item{root}{Character. The string displayed as the root (center) of the mind map.}

\item{md_list}{Logical. whether to process lists like headings in the Markdown input.}

\item{md_eq}{Logical. Whether to include LaTeX equations in the Markdown input when converted to other formats.}

\item{md_braces}{Logical. Whether to remove \href{https://bookdown.org/yihui/bookdown/cross-references.html}{{#ID}} in the headings of the markdown file (usually in a \href{https://github.com/rstudio/bookdown}{bookdown}> project.}

\item{md_bookdown}{Logical. Whether the R Markdown syntax text is in bookdown style, i.e. \code{# (PART), # (APPENDIX)}, and \code{# References} as an upper level of the Level 1 heading.}

\item{md_maxlevel}{Integer or ''. The maximum level of the markdown headings that are displayed in the mind map.}

\item{r_seclabel}{Character. The ending characters indicating sections in R Markdown.}

\item{r_chunkheading}{Logical. Whether process the chunk label as headings.}

\item{dir_files}{Logical. Whether to include files. If \code{FALSE}, only folders are included. If \code{TRUE}, folders and files are included.}

\item{dir_all}{Logical. Whether to include all files in a directory. If \code{FALSE}, only the names of visible files are included (following Unix-style visibility, that is files whose name does not start with a dot). If \code{TRUE}, all file names will be included.}

\item{dir_excluded}{Character. The directories which are not included in the output.}

\item{dir_to}{Character. The path of the output directory.}

\item{dir_quiet}{Logical. Whether to display the results of generated directories.}

\item{mmd_shape}{Character. The shape of mermaid mindmap nodes. See \href{https://bookdown.org/yihui/bookdown/cross-references.html}{{Mermaid document}}.}

\item{widget_name}{Character. The name of the html widget.}

\item{widget_width}{Numeric. The width of the widget.}

\item{widget_height}{Numeric. The height of the widget.}

\item{widget_elementId}{Character. The ID of teh Widget.}

\item{widget_options}{List. Options for the markmap widget. It should be a list passed from the \code{markmapOption()} function.}
}
\value{
Desired output.
}
\description{
Convert almost any file into mind map.
}
\details{
The input file type could be .md, .Rmd, .qmd, .R, .mm, .pdf, .docx, .html, .rtf, .odt, .epub, .tex, and any other types which pandoc can convert from. See \href{https://pandoc.org/}{pandoc} for more details.
}
\examples{
mp <- mmm(input_file = system.file('examples/mindr-md.Rmd', package = 'mindr'))
mp
# See the vignette for more examples:
vignette('mindr', package = 'mindr')
}
