% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen.difficulty.R
\name{gen.difficulty}
\alias{gen.difficulty}
\title{Generalized item difficulty summaries}
\usage{
gen.difficulty(mod, type = "IRF", interval = c(-30, 30), ...)
}
\arguments{
\item{mod}{a single factor model estimated by \code{\link{mirt}}}

\item{type}{type of generalized difficulty parameter to report.
Can be \code{'IRF'} to use the item response function (default),
\code{'mean'} to find the average of the difficulty estimates,
\code{'median'} the median of the difficulty estimates, and
\code{'trimmed'} to find the trimmed mean after removing the first
and last difficulty estimates}

\item{interval}{interval range to search for \code{'IRF'} type}

\item{...}{additional arguments to pass to \code{\link{uniroot}}}
}
\description{
Function provides the four generalized item difficulty representations
for polytomous response models described by Ali, Chang, and Anderson (2015).
These estimates are used to gauge how difficult a polytomous item may be.
}
\examples{

\donttest{

mod <- mirt(Science, 1)
coef(mod, simplify=TRUE, IRTpars = TRUE)$items

gen.difficulty(mod)
gen.difficulty(mod, type = 'mean')

# also works for dichotomous items (though this is unnecessary)
dat <- expand.table(LSAT7)
mod <- mirt(dat, 1)
coef(mod, simplify=TRUE, IRTpars = TRUE)$items

gen.difficulty(mod)
gen.difficulty(mod, type = 'mean')

}
}
\references{
Ali, U. S., Chang, H.-H., & Anderson, C. J. (2015). \emph{Location indices for ordinal
polytomous items based on item response theory} (Research Report No. RR-15-20).
Princeton, NJ: Educational Testing Service. http://dx.doi.org/10.1002/ets2.12065

Chalmers, R., P. (2012). mirt: A Multidimensional Item Response Theory
Package for the R Environment. \emph{Journal of Statistical Software, 48}(6), 1-29.
\doi{10.18637/jss.v048.i06}
}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
