% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kl_pie.R
\name{kl_pie}
\alias{kl_pie}
\title{Kullback-Leibler Divergence for Probability Matrices}
\usage{
kl_pie(P, Q, min_value = 1e-12)
}
\arguments{
\item{P}{A numeric matrix representing the first probability distribution.
Should sum to 1 (or will be treated as unnormalized).}

\item{Q}{A numeric matrix representing the second probability distribution.
Must have the same dimensions as P.}

\item{min_value}{Numeric. Minimum value to replace zeros (to avoid
undefined logarithms). Default: 1e-12.}
}
\value{
A named numeric vector with two elements:
\itemize{
\item \code{"P || Q"}: KL divergence from P to Q
\item \code{"Q || P"}: KL divergence from Q to P
}
}
\description{
Computes the Kullback-Leibler (KL) divergence between two probability
matrices using base-10 logarithm. Calculates divergence in both directions.

This is useful for comparing conditional probability tables (CPTs) or
other matrix representations of probability distributions.
}
\details{
The KL divergence is computed as:
\deqn{KL(P || Q) = \sum_i P_i \log_{10}(P_i / Q_i)}

Zero values in P or Q are replaced with \code{min_value} to avoid
undefined operations.
}
\examples{
# Compare two CPTs
cpt1 <- cpt_population()
cpt2 <- cpt_population(propS = c(0.6, 0.4))

kl_pie(cpt1, cpt2)
}
\references{
Kullback S, Leibler RA (1951). "On Information and Sufficiency."
\emph{The Annals of Mathematical Statistics}, 22(1), 79-86.
}
\seealso{
\code{\link{kl_bidirectional}} for allele frequency comparisons,
\code{\link{cpt_population}}, \code{\link{cpt_missing_person}} for
creating probability matrices.
}
