% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot,MizerParams,missing-method}
\alias{plot,MizerParams,missing-method}
\title{Summary plot for \code{MizerParams} objects}
\usage{
\S4method{plot}{MizerParams,missing}(x, y, ...)
}
\arguments{
\item{x}{An object of class \linkS4class{MizerParams}}

\item{y}{Not used}

\item{...}{For additional arguments see the documentation for
\code{\link[=plotFeedingLevel]{plotFeedingLevel()}},\code{\link[=plotSpectra]{plotSpectra()}},\code{\link[=plotPredMort]{plotPredMort()}}}
}
\value{
A viewport object
}
\description{
Produces 3 plots in the same window: abundance spectra, feeding
level and predation mortality of each species through time. This method just
uses the other plotting functions and puts them all in one window.
}
\examples{
\donttest{
params <-  NS_params
plot(params)
}
}
\seealso{
\link{plotting_functions}

Other plotting functions: 
\code{\link{animateSpectra}()},
\code{\link{plot,MizerSim,missing-method}},
\code{\link{plotBiomass}()},
\code{\link{plotDiet}()},
\code{\link{plotFMort}()},
\code{\link{plotFeedingLevel}()},
\code{\link{plotGrowthCurves}()},
\code{\link{plotPredMort}()},
\code{\link{plotSpectra}()},
\code{\link{plotYield}()},
\code{\link{plotYieldGear}()},
\code{\link{plotting_functions}}
}
\concept{plotting functions}
