% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxhelp.R
\name{CPOConstructor}
\alias{CPOConstructor}
\title{Constructor for CPO Objects}
\arguments{
\item{id}{[\code{character(1)} | \code{NULL}]\cr
ID to use for the CPO. if \code{NULL} is given, this defaults to
a name describing the action performed by the CPO, which can be retrieved using \code{\link{getCPOName}}.
The ID is used to identify the CPO in print messages,
and is prefixed to the CPO's hyperparameter names. This is can be used to avoid name clashes when composing
a CPO with another CPO or \code{\link[mlr:makeLearner]{Learner}} with hyperparameters with clashing names. Default is \code{NULL}.}

\item{export}{[\code{character}]\cr
Which hyperparameters to export. This can be a character vector naming the
hyperparameters to export (\emph{excluding} the ID), or a \code{character(1)} with one of the special values:
\tabular{ll}{
  \dQuote{export.all}            \tab  export all parameters                             \cr
  \dQuote{export.default}        \tab  exp. params that are exp. by def                  \cr
  \dQuote{export.set}            \tab  exp. params set in construct call                 \cr
  \dQuote{export.default.set}    \tab  intersection of \dQuote{default} and \dQuote{set} \cr
  \dQuote{export.unset}          \tab  params \emph{not} set in construct call           \cr
  \dQuote{export.default.unset}  \tab  isct. of \dQuote{default} and \dQuote{unset}      \cr
  \dQuote{export.all.plus}       \tab  not yet supported
}
Default is \dQuote{export.default}.}

\item{affect.type}{[\code{character} | \code{NULL}]\cr
Type of columns to affect. May be a subset of \dQuote{numeric}, \dQuote{factor}, \dQuote{ordered}, \dQuote{other},
or can be or \code{NULL} to match all columns. Default is \code{NULL}.}

\item{affect.index}{[\code{numeric}]\cr
Indices of feature columns to affect. The order of indices given is respected. Default is \code{integer(0)}.}

\item{affect.names}{[\code{character}]\cr
Feature names of feature columns to affect. The order of names given is respected. Default is \code{character(0)}.}

\item{affect.pattern}{[\code{character(1)} | \code{NULL}]\cr
\code{\link[base]{grep}} pattern to match feature names by. Default is \code{NULL} (no pattern matching)}

\item{affect.invert}{[\code{logical(1)}]\cr
Whether to affect all features \emph{not} matched by other \code{affect.*} parameters. Default is \code{FALSE}.}

\item{affect.pattern.ignore.case}{[\code{logical(1)}]\cr
Ignore case when matching features with \code{affect.pattern}; see \code{\link[base]{grep}}. Has no effect when
\code{affect.pattern} is \code{NULL}. Default is \code{FALSE}.}

\item{affect.pattern.perl}{[\code{logical(1)}]\cr
Use Perl-style regular expressions for \code{affect.pattern}; see \code{\link[base]{grep}}. Has no effect when
\code{affect.pattern} is \code{NULL}, or when \code{affect.pattern.fixed} is \code{TRUE}. Default is \code{FALSE}.}

\item{affect.pattern.fixed}{[\code{logical(1)}]\cr
Use fixed matching instead of regular expressions for \code{affect.pattern}; see \code{\link[base]{grep}}.
Has no effect when \code{affect.pattern} is \code{NULL}. Default is \code{FALSE}.}
}
\value{
[\code{\link{CPO}}] the constructed CPO.
}
\description{
\code{\link{CPO}} objects are created by calling \code{CPOConstructor}s, which are
R functions that have some parameters in common, use a convenient \code{\link{print.CPOConstructor}} generic,
and always return a \code{\link{CPO}} object. The mlrCPO package provides many \code{CPOConstructor}
functions, which can be listed using \code{\link{listCPO}}. It is also possible to
create custom \code{\link{CPOConstructor}}s using \code{\link{makeCPO}}, \code{\link{makeCPORetrafoless}},
\code{link{makeCPOTargetOp}}, and \code{\link{makeCPOExtendedTrafo}}.
}
\section{CPO creation}{

CPOConstructors can be called like any R function, with any parameters given. Besides parameters that are
common to most CPOConstructors (listed below), it is possible to set CPO-specific hyperparameters in the
construction. Parameters that are being \emph{exported}  can also be modified later using the \code{\link{CPO}}
object, see the documentation there.
}

\section{\code{affect.*} parameters}{

When creating a \code{\link{CPO}}, it is possible to choose which columns of the given data the CPO operates
on, and which columns it will ignore. This is done using the \code{affect.*} parameters. It is possible to
choose columns by types, indices, names, or a regular expression matching names.
}

\examples{
class(cpoPca)  # c("CPOConstructor", "function")
print(cpoPca)  # default printer
print(cpoPca, verbose = TRUE)  # shows the trafo / retrafo functions

cpoPca()  # creating a CPO
class(cpoPca())  # c("CPOPrimitive", "CPO")

}
\seealso{
\code{\link{print.CPOConstructor}} for possibly verbose printing.

Other CPO lifecycle related: 
\code{\link{CPO}},
\code{\link{CPOLearner}},
\code{\link{CPOTrained}},
\code{\link{NULLCPO}},
\code{\link{\%>>\%}()},
\code{\link{attachCPO}()},
\code{\link{composeCPO}()},
\code{\link{getCPOClass}()},
\code{\link{getCPOConstructor}()},
\code{\link{getCPOTrainedCPO}()},
\code{\link{identicalCPO}()},
\code{\link{makeCPO}()}

Other CPOConstructor related: 
\code{\link{getCPOClass}()},
\code{\link{getCPOConstructor}()},
\code{\link{getCPOName}()},
\code{\link{identicalCPO}()},
\code{\link{makeCPO}()},
\code{\link{print.CPOConstructor}()}
}
\concept{CPO lifecycle related}
\concept{CPOConstructor related}
