% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CPO_fixFactors.R
\name{cpoFixFactors}
\alias{cpoFixFactors}
\title{Clean Up Factorial Features}
\usage{
cpoFixFactors(
  drop.unused.levels = TRUE,
  fix.factors.prediction = TRUE,
  id,
  export = "export.default",
  affect.type = NULL,
  affect.index = integer(0),
  affect.names = character(0),
  affect.pattern = NULL,
  affect.invert = FALSE,
  affect.pattern.ignore.case = FALSE,
  affect.pattern.perl = FALSE,
  affect.pattern.fixed = FALSE
)
}
\arguments{
\item{drop.unused.levels}{Factor levels of data that have no instances in the data are dropped. If
\dQuote{fix.factors.prediction} is false, this can lead to training data having
different factor levels than prediction data. Default is \code{TRUE}.}

\item{fix.factors.prediction}{Factor levels are kept the same in training and prediction. This is
recommended. Default is \code{TRUE}.}

\item{id}{[\code{character(1)}]\cr
id to use as prefix for the CPO's hyperparameters. this
must be used to avoid name clashes when composing two
CPOs of the same type, or with learners or other CPOS
with hyperparameters with clashing names.}

\item{export}{[\code{character}]\cr
Either a character vector indicating the parameters to
export as hyperparameters, or one of the special values
\dQuote{export.all} (export all parameters),
\dQuote{export.default} (export all parameters that are exported by default),
\dQuote{export.set} (export all parameters that were set during construction),
\dQuote{export.default.set} (export the intersection of the \dQuote{default} and \dQuote{set} parameters),
\dQuote{export.unset} (export all parameters that were \emph{not} set during construction) or
\dQuote{export.default.unset} (export the intersection of the \dQuote{default} and \dQuote{unset} parameters).
Default is \dQuote{export.default}.}

\item{affect.type}{[\code{character} | \code{NULL}]\cr
Type of columns to affect. A subset of \dQuote{numeric}, \dQuote{factor}, \dQuote{ordered}, \dQuote{other}, or \code{NULL}
to not match by column type. Default is \code{NULL}.}

\item{affect.index}{[\code{numeric}]\cr
Indices of feature columns to affect. The order of indices given is respected. Target column indices are not counted
(since target columns are always included). Default is \code{integer(0)}.}

\item{affect.names}{[\code{character}]\cr
Feature names of feature columns to affect. The order of names given is respected. Default is \code{character(0)}.}

\item{affect.pattern}{[\code{character(1)} | \code{NULL}]\cr
\code{\link[base]{grep}} pattern to match feature names by. Default is \code{NULL} (no pattern matching)}

\item{affect.invert}{[\code{logical(1)}]\cr
Whether to affect all features \emph{not} matched by other \code{affect.*} parameters.}

\item{affect.pattern.ignore.case}{[\code{logical(1)}]\cr
Ignore case when matching features with \code{affect.pattern}; see \code{\link[base]{grep}}. Default is \code{FALSE}.}

\item{affect.pattern.perl}{[\code{logical(1)}]\cr
Use Perl-style regular expressions for \code{affect.pattern}; see \code{\link[base]{grep}}. Default is \code{FALSE}.}

\item{affect.pattern.fixed}{[\code{logical(1)}]\cr
Use fixed matching instead of regular expressions for \code{affect.pattern}; see \code{\link[base]{grep}}. Default is \code{FALSE}.}
}
\value{
[\code{\link{CPO}}].
}
\description{
This is a \code{\link{CPOConstructor}} to be used to create a
\code{\link{CPO}}. It is called like any R function and returns
the created \code{\link{CPO}}.

Prevent common pitfalls when using factorial data, by making factorial data have the
same levels in training and prediction, and by dropping factor levels that do not
occur in training data.
}
\section{General CPO info}{

This function creates a CPO object, which can be applied to
\code{\link[mlr]{Task}}s, \code{data.frame}s, \code{link[mlr]{Learner}}s
and other CPO objects using the \code{\link{\%>>\%}} operator.

The parameters of this object can be changed after creation
using the function \code{\link[mlr]{setHyperPars}}. The other
hyper-parameter manipulating functins, \code{\link[mlr]{getHyperPars}}
and \code{\link[ParamHelpers]{getParamSet}} similarly work as one expects.

If the \dQuote{id} parameter is given, the hyperparameters
will have this id as aprefix; this will, however, not change
the parameters of the creator function.
}

\section{Calling a \code{\link{CPOConstructor}}}{

CPO constructor functions are called with optional values of parameters, and additional \dQuote{special} optional values.
The special optional values are the \code{id} parameter, and the \code{affect.*} parameters. The \code{affect.*} parameters
enable the user to control which subset of a given dataset is affected. If no \code{affect.*} parameters are given, all
data features are affected by default.
}

\seealso{
Other CPOs: 
\code{\link{cpoApplyFun}()},
\code{\link{cpoApplyFunRegrTarget}()},
\code{\link{cpoAsNumeric}()},
\code{\link{cpoCache}()},
\code{\link{cpoCbind}()},
\code{\link{cpoCollapseFact}()},
\code{\link{cpoDropConstants}()},
\code{\link{cpoDropMostlyConstants}()},
\code{\link{cpoDummyEncode}()},
\code{\link{cpoFilterAnova}()},
\code{\link{cpoFilterCarscore}()},
\code{\link{cpoFilterChiSquared}()},
\code{\link{cpoFilterFeatures}()},
\code{\link{cpoFilterGainRatio}()},
\code{\link{cpoFilterInformationGain}()},
\code{\link{cpoFilterKruskal}()},
\code{\link{cpoFilterLinearCorrelation}()},
\code{\link{cpoFilterMrmr}()},
\code{\link{cpoFilterOneR}()},
\code{\link{cpoFilterPermutationImportance}()},
\code{\link{cpoFilterRankCorrelation}()},
\code{\link{cpoFilterRelief}()},
\code{\link{cpoFilterRfCImportance}()},
\code{\link{cpoFilterRfImportance}()},
\code{\link{cpoFilterRfSRCImportance}()},
\code{\link{cpoFilterSymmetricalUncertainty}()},
\code{\link{cpoFilterUnivariate}()},
\code{\link{cpoFilterVariance}()},
\code{\link{cpoIca}()},
\code{\link{cpoImpactEncodeClassif}()},
\code{\link{cpoImpactEncodeRegr}()},
\code{\link{cpoImpute}()},
\code{\link{cpoImputeConstant}()},
\code{\link{cpoImputeHist}()},
\code{\link{cpoImputeLearner}()},
\code{\link{cpoImputeMax}()},
\code{\link{cpoImputeMean}()},
\code{\link{cpoImputeMedian}()},
\code{\link{cpoImputeMin}()},
\code{\link{cpoImputeMode}()},
\code{\link{cpoImputeNormal}()},
\code{\link{cpoImputeUniform}()},
\code{\link{cpoLogTrafoRegr}()},
\code{\link{cpoMakeCols}()},
\code{\link{cpoMissingIndicators}()},
\code{\link{cpoModelMatrix}()},
\code{\link{cpoOversample}()},
\code{\link{cpoPca}()},
\code{\link{cpoProbEncode}()},
\code{\link{cpoQuantileBinNumerics}()},
\code{\link{cpoRegrResiduals}()},
\code{\link{cpoResponseFromSE}()},
\code{\link{cpoSample}()},
\code{\link{cpoScale}()},
\code{\link{cpoScaleMaxAbs}()},
\code{\link{cpoScaleRange}()},
\code{\link{cpoSelect}()},
\code{\link{cpoSmote}()},
\code{\link{cpoSpatialSign}()},
\code{\link{cpoTransformParams}()},
\code{\link{cpoWrap}()},
\code{\link{makeCPOCase}()},
\code{\link{makeCPOMultiplex}()}
}
\concept{CPOs}
